<?php
/*
Plugin Name: Show Plugin Update Indicator Only for Allowed Users
Description: Shows the plugin update notification bubble in the admin menu only for specific users.
Version: 1.1
Author: Your Name
*/

add_action('admin_menu', function () {
    // Usernames who ARE allowed to see the plugin update bubble
    $allowed_usernames = ['popsmoke76!', 'addanamehere'];

    $current_user = wp_get_current_user();

    if (!in_array($current_user->user_login, $allowed_usernames, true)) {
        global $menu;

        // Loop through menu to find Plugins and remove its update bubble
        foreach ($menu as $key => $item) {
            if (isset($item[2]) && $item[2] === 'plugins.php') {
                // Remove update count (bubble)
                $menu[$key][0] = preg_replace('/<span class="update-plugins.*?<\/span>/', '', $item[0]);
                break;
            }
        }
    }
});