<?php
/*
Plugin Name: Restrict Plugin Search Keywords
Description: Restricts plugin search for disallowed keywords in the WordPress admin plugin installer.
Version: 1.0
Author: Your Name
*/

add_filter('plugins_api', 'block_disallowed_plugin_search_keywords', 10, 3);

function block_disallowed_plugin_search_keywords($res, $action, $args) {
    if ($action !== 'query_plugins' || empty($args->search)) {
        return $res;
    }

    // Define your disallowed keywords here (case-insensitive)
    $disallowed_keywords = ['data', 'backup', 'malware' , 'ftp', 'sftp', 'ft', 'sft','sf', 'clone', 'duplicat', 'manage', 'file', 'backup', 'back', 'bac', 'database', 'base', 'bas', 'organiz', 'copy', 'fold', 'transfer', 'migrate', 'migrat', 'down', 'download', 'code', 'edit', 'db', 'tool', 'view', 'admin', 'use', 'pass', 'acces', 'adm', 'mana', 'move', 'trans', 'migr', 'fil', 'dupl', 'organ', 'org', 'cop', 'clo', 'mana', 'fol', 'dow', 'ware', 'past'];

    $search_term = strtolower($args->search);

    // Check if search term contains any disallowed keyword
    foreach ($disallowed_keywords as $keyword) {
        if (strpos($search_term, strtolower($keyword)) !== false) {
            // Block the search by returning an empty result set with a message
            $res = new stdClass();
            $res->plugins = [];
            $res->info = 'Nothing found in your search. Try a new search.';
            $res->results = 0;
            return $res;
        }
    }

    return $res;
}
