<?php
/**
 * Plugin Name: Hide "Manage with Live Preview" Button for Specific Users
 * Description: Hide the "Manage with Live Preview" button based on usernames.
 * Author: Your Name
 * Version: 1.0
 */

// Hook to remove the "Manage with Live Preview" button
function hide_live_preview_button_for_users() {
    // Array of restricted usernames who should not see the "Manage with Live Preview" button
    $restricted_usernames = array('ngoannie', 'restricteduser2', 'restricteduser3');

    // Get the current logged-in user's username
    $current_user = wp_get_current_user();
    $current_username = $current_user->user_login;

    // If the current user is in the restricted list, remove the button
    if (in_array($current_username, $restricted_usernames)) {
        add_action('wp_footer', 'remove_live_preview_button', 100);
    }
}
add_action('admin_init', 'hide_live_preview_button_for_users');

// Function to remove the "Manage with Live Preview" button
function remove_live_preview_button() {
    echo "<style>#wp-admin-bar-customize { display: none !important; }</style>";
}