<?php
if ( !function_exists( 'add_action' ) ) {
    echo 'Code is poetry.';
    exit;
}

if( get_option("dadb_start") == 1 ) {
	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//TOTAL BLOCKED
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////	
	function totalBlocked() {
		
		$COUNTSpam = get_option("dadb_bu")+get_option("dadb_nn")+get_option("dadb_fn")+get_option("dadb_rn")+get_option("dadb_bm")+get_option("dadb_bcm"); 
		
		return $COUNTSpam;
		
	}
		
		
	 /**
	 * Adds total blocked widget
	 */
		class Blocked_Spams extends WP_Widget {

			/**
			 * Register widget with WordPress.
			 */
			function __construct() {
				parent::__construct(
					'Blocked_Spams', // Base ID
					esc_html__( 'Blocker. Widget', 'dadb-plugin' ), // Name
					array( 'description' => esc_html__( 'Blocker. Plugin - Total Blocked Spams', 'dadb-plugin' ), ) // Args
				);
			}

			/**
			 * Front-end display of widget.
			 *
			 * @see WP_Widget::widget()
			 *
			 * @param array $args     Widget arguments.
			 * @param array $instance Saved values from database.
			 */
			public function widget( $args, $instance ) {
				echo $args['before_widget'];
				if ( ! empty( $instance['title'] ) ) {
					echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . __( ' by Blocker.', 'dadb-plugin') . $args['after_title'];
				}
				
				if ( empty($instance['color']) ) {
					$color = "#5a99d4";
				} else {
					$color = $instance['color'];
				}			
				
				if ( empty($instance['st']) ) {
					$st = "SPAM";
				} else {
					$st = $instance['st'];
				}
				
				if ( $instance['type'] == 1 ) {
					echo "<span title='".totalBlocked()." spam attempts blocked by Blocker Plugin.' style='background:".$color."' class='pulse-button'>".totalBlocked()." ". $st."</span>";
				} else {
					echo "<span title='".totalBlocked()." spam attempts blocked by Blocker Plugin.' style='background:".$color."' class='pulse-button-wth'>".totalBlocked()." ". $st ."</span>";
				}
				
				
				echo $args['after_widget'];
			}

			/**
			 * Back-end widget form.
			 *
			 * @see WP_Widget::form()
			 *
			 * @param array $instance Previously saved values from database.
			 */
			public function form( $instance ) {
				$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Blocked Spams', 'dadb-plugin' );
				$color = ! empty( $instance['color'] ) ? $instance['color'] : esc_html__( '#5a99d4', 'dadb-plugin' );
				$type = ! empty( $instance['type'] ) ? $instance['type'] : $type = "2";
				$st = ! empty( $instance['st'] ) ? $instance['st'] : $st = "SPAM";
				?>
				<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Button Title:', 'dadb-plugin' ); ?></label> 
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
				</p>			
				
				<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'st' ) ); ?>"><?php esc_attr_e( 'Spam Text:', 'dadb-plugin' ); ?></label> 
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'st' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'st' ) ); ?>" type="text" value="<?php echo esc_attr( $st ); ?>">
				</p>
				
				<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Button Color:', 'dadb-plugin' ); ?></label> 
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'color' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'color' ) ); ?>" type="text" value="<?php echo esc_attr( $color ); ?>">
				</p>			
				
				<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Button Type:', 'dadb-plugin' ); ?></label> <br>
				<input type="radio" id="<?php echo esc_attr( $this->get_field_id( 'type' ) ); ?>"  name="<?php echo esc_attr( $this->get_field_name( 'type' ) ); ?>" value="1" <?php if ($type == 1) { echo "checked"; } ?>><?php esc_attr_e( 'With Animation', 'dadb-plugin' ); ?><br>
				<input type="radio" id="<?php echo esc_attr( $this->get_field_id( 'type' ) ); ?>"  name="<?php echo esc_attr( $this->get_field_name( 'type' ) ); ?>" value="2" <?php if ($type == 2) { echo "checked"; } ?>><?php esc_attr_e( 'Without Animation', 'dadb-plugin' ); ?>
				</p>
				<?php 
			}

			/**
			 * Sanitize widget form values as they are saved.
			 *
			 * @see WP_Widget::update()
			 *
			 * @param array $new_instance Values just sent to be saved.
			 * @param array $old_instance Previously saved values from database.
			 *
			 * @return array Updated safe values to be saved.
			 */
			public function update( $new_instance, $old_instance ) {
				$instance = array();
				$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
				$instance['color'] = ( ! empty( $new_instance['color'] ) ) ? sanitize_text_field( $new_instance['color'] ) : '';
				$instance['type'] = ( ! empty( $new_instance['type'] ) ) ? sanitize_text_field( $new_instance['type'] ) : '';
				$instance['st'] = ( ! empty( $new_instance['st'] ) ) ? sanitize_text_field( $new_instance['st'] ) : '';

				return $instance;
			}

		} // class Blocked_Spams

		function register_Blocked_Spams() {
			register_widget('Blocked_Spams');
		}
		
		function widgetCSS() {
			wp_enqueue_style( 'dadb-style', DADB_URL."admin/assets/css/widget.css",array(), "1.0.0" );
		}
		
		add_action( 'wp_enqueue_scripts', 'widgetCSS' );
		add_action( 'widgets_init', 'register_Blocked_Spams' );
}