<?php

/*
  Plugin Name: Printoflauge
  Plugin URI: http://yooplugins.com/
  Author: Rynaldo Stoltz
  Author URI: http://yooplugins.com/
  Description: Printoflauge (Printing Camoflauge) is a CSS based plugin that clears the printing clipboard of the user attempting to print your pages (using the browser printing function) - and replaces it with a warning message. See <a href="options-general.php?page=printouflage">Printoflauge Settings</a> for instructions. 
  Version: 0.2.2
*/

/**
  Copyright 2013/2014 Rynaldo Stoltz | yooplugins.com (Printouflauge) - All Rights Reserved
  This Software should not be used or changed without the permission of yooplugins.com 
  For further clarifications and licensing support, reach us by email: support@yooplugins.com or visit our website here: http://yooplugins.com/
 */

if (!class_exists("printouflage")) {
    class printouflage {
        var $adminOptionsName = 'printouflage_admin';

        function printouflage() {}
		
        function init() {
            $this -> getAdminOptions();
        }

        function getAdminOptions() {
            $printouflage_admin = array(
                'printouflage_enabled' => 'true',);
            $printouflage_options = get_option($this->adminOptionsName);
            if (!empty($printouflage_options)) {
                foreach ($printouflage_options as $key => $option)
                    $printouflage_admin[$key] = $option;
            }
            update_option($this -> adminOptionsName, $printouflage_admin);
            return $printouflage_admin;
        }

        function printouflage_header() {
            print '<link rel="stylesheet"  type="text/css" href="' . plugins_url('printouflage/css/cp.css') . '" media="print" />';
        }

        function printAdminPage() {
            $options = $this -> getAdminOptions();
            if (isset($_POST['update_wp_printouflage'])) {
                if (isset($_POST['printouflage_enabled'])) {
                    $options['printouflage_enabled'] = $_POST['printouflage_enabled'];
                }
                update_option($this -> adminOptionsName, $options);
                print '<div class="updated">';
                _e("Settings Saved Successfully", "printouflage");
                print '</div>';
            }
            include('config/config.php');
        }
    }
}

$inst_printouflage = new printouflage();

$options = $inst_printouflage -> getAdminOptions();
if($options['printouflage_enabled']=='true')
    add_action('wp_head', array ( &$inst_printouflage, 'printouflage_header'), 1);

if (!function_exists("printouflage_ap")) {
    function printouflage_ap() {
        global $inst_printouflage;
        if (!isset($inst_printouflage)) {
            return;
        }
        if (function_exists('add_options_page')) {
            add_options_page('Printouflage Settings', 'Printouflage', 'manage_options', 'printouflage', array ( &$inst_printouflage, 'printAdminPage'));
        }
    }
}

function printouflage_conf_link($links) { 
  $settings_link = '<a href="options-general.php?page=printouflage">Settings</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}

$plugin = plugin_basename(__FILE__);

add_filter("plugin_action_links_$plugin", 'printouflage_conf_link' );
add_action('admin_menu', 'printouflage_ap');
add_action('activate_printouflage/printouflage.php', array(&$inst_printouflage, 'init'));