<?php
/**
 * Add Menu Page
 */
if ( ! function_exists('is_plugin_active') ){ include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); }
add_action( 'admin_menu', 'htpmpro_submenu' );
function htpmpro_submenu() {

	$menu = 'add_menu_' . 'page';
    $menu(
        'htpmpro_plugin_panel',
        esc_html__( 'Plugin Manager', 'htpmpro' ),
        esc_html__( 'Plugin Manager', 'htpmpro' ),
        'htpmpro_page',
        NULL,
        HTPMPRO_ROOT_URL . '/assets/images/menu-icon.png',
        65
    );

	add_submenu_page( 
		'htpmpro_page', 
		esc_html__('Settings', 'htpmpro'), 
		esc_html__('Settings', 'htpmpro'), 
		'manage_options', 
		'htpmpro-options', 
		'htpmpro_options_page_html'
	);

}

/**
 * Render the option page
 */
function htpmpro_options_page_html() {
	 // check user capabilities
	 if ( ! current_user_can( 'manage_options' ) ) {
	 	return;
	 }

	 // show message when updated
	 if ( isset( $_GET['settings-updated'] ) ) {
	 	add_settings_error( 'htpmpro_messages', 'htpmpro_message', esc_html__( 'Settings Saved', 'htpmpro' ), 'updated' );
	 }
	 
	 // show error/update messages
	 settings_errors( 'htpmpro_messages' );
	 ?>
		<div class="wrap">
			<h1><?php echo esc_html( 'WP Plugin Manager' ); ?> <?php echo esc_html( get_admin_page_title() ); ?></h1>
			<h2 class="nav-tab-wrapper">
			 	<a href="#htpmpro-tab-1" class="htpmpro-nav nav-tab nav-tab-active"><?php esc_html_e('Plugin Manager Option', 'htpmpro')?></a>
			 	<a href="#htpmpro-tab-2" class="htpmpro-nav nav-tab"><?php esc_html_e('Our Plugins', 'htpmpro')?></a>
			</h2>
			<div id="htpmpro-tab-1" class="htpmpro-tab-group htpmpro-active-tab">
				<form action="options.php" method="post">
					<?php
						// output general section and their fields
						do_settings_sections( 'options_group_general' );

						// general option fields
						settings_fields( 'options_group_general' );

						// output save settings button
						submit_button( 'Save Settings' );
					?>
				</form>
			</div>
			<div id="htpmpro-tab-2" class="htpmpro-tab-group">
				<div class="htpmpro-row">
		        	<div class="htpmpro-column-2">
		                <div class="htpmpro-singleplugin">
		                	<div class="htpmpro-thumb">
		                		<img src="<?php echo HTPMPRO_ROOT_URL . '/assets/images/plugins-image/woolentor.png' ?>">
		                	</div>
		                	<div class="htpmpro-content">
			                    <h3><?php esc_html_e( 'Woolentor Pro','htpmpro' );?></h3>
			                    <p><?php esc_html_e( 'WooLentor is a most popular WooCommerce Elementor Addon on WordPress.org. Downloaded more than 100,000 times and 15,000 stores are using WooLentor plugin.', 'htpmpro' )?></p>
			                    <div class="htpmpro-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/woolentor-pro-woocommerce-page-builder/" target="_blank"><?php esc_html_e( 'More Details', 'htpmpro' )?></a>
			                       
			                        <?php htpmpro_plugin_install_button( 'woolentor-addons/woolentor_addons_elementor.php','woolentor-addons' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="htpmpro-column-2">
		                <div class="htpmpro-singleplugin">
		                	<div class="htpmpro-thumb">
		                		<img src="<?php echo HTPMPRO_ROOT_URL . '/assets/images/plugins-image/ht-mega.png' ?>">
		                	</div>
		                	<div class="htpmpro-content">
			                    <h3><?php esc_html_e( 'HT Mega','htpmpro' );?></h3>
			                    <p><?php esc_html_e( 'HTMega is a absolute addons for elementor includes 80+ elements & 360 Blocks with unlimited variations.', 'htpmpro' )?></p>
			                    <div class="htpmpro-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/ht-mega-pro/" target="_blank"><?php esc_html_e( 'More Details', 'htpmpro' )?></a>
			                       
			                        <?php htpmpro_plugin_install_button( 'ht-mega-for-elementor/htmega_addons_elementor.php','ht-mega-for-elementor' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="htpmpro-column-2">
		                <div class="htpmpro-singleplugin">
		                	<div class="htpmpro-thumb">
		                		<img src="<?php echo HTPMPRO_ROOT_URL . '/assets/images/plugins-image/multy-currency.png' ?>">
		                	</div>
		                	<div class="htpmpro-content">
			                    <h3><?php esc_html_e( 'Multi Currency Pro for WooCommerce','htpmpro' );?></h3>
			                    <p><?php esc_html_e( 'Multi-Currency Pro for WooCommerce is a prominent currency switcher plugin for WooCommerce.', 'htpmpro' )?></p>
			                    <div class="htpmpro-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/multi-currency-pro-for-woocommerce/" target="_blank"><?php esc_html_e( 'More Details', 'htpmpro' )?></a>
			                        <?php htpmpro_plugin_install_button( 'wc-multi-currency/wcmilticurrency.php','wc-multi-currency' ); ?>
			                    </div>
		                    </div>
		                </div>
		            </div>
		            <div class="htpmpro-column-2">
		                <div class="htpmpro-singleplugin">
		                	<div class="htpmpro-thumb">
		                		<img src="<?php echo HTPMPRO_ROOT_URL . '/assets/images/plugins-image/ht-script.png' ?>">
		                	</div>

		                	<div class="htpmpro-content">
			                    <h3><?php esc_html_e( 'HT Script - Insert Headers and Footers Code','htpmpro' );?></h3>
			                    <p><?php esc_html_e( 'Insert Headers and Footers Code allows you to insert Google Analytics, Facebook Pixel, custom CSS, custom HTML, JavaScript code to your website header and footer without modifying your theme code.', 'htpmpro' )?></p>
			                    <div class="htpmpro-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/insert-headers-and-footers-code-ht-script/" target="_blank"><?php esc_html_e( 'More Details', 'htpmpro' )?></a>
			                        <?php htpmpro_plugin_install_button( 'insert-headers-and-footers-script/init.php','insert-headers-and-footers-script' ); ?>
			                    </div>
		                	</div>
		                </div>
		            </div>
		            <div class="htpmpro-column-2">
		                <div class="htpmpro-singleplugin">
		                	<div class="htpmpro-thumb">
		                		<img src="<?php echo HTPMPRO_ROOT_URL . '/assets/images/plugins-image/hashbar.png' ?>">
		                	</div>
		                	<div class="htpmpro-content">
			                    <h3><?php esc_html_e( 'HashBar Pro','htpmpro' );?></h3>
			                    <p><?php esc_html_e( 'HashBar is a WordPress Notification / Alert / Offer Bar plugin which allows you to create unlimited notification bars.This plugin has option to show email subscription form, Offer text and buttons about your promotions', 'htpmpro' )?></p>
			                    <div class="htpmpro-button-area">
			                        <a class="button primary" href="https://hasthemes.com/wordpress-notification-bar-plugin/" target="_blank"><?php esc_html_e( 'More Details', 'htpmpro' )?></a>
			                        <?php htpmpro_plugin_install_button( 'hashbar-wp-notification-bar/init.php','hashbar-wp-notification-bar' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="htpmpro-column-2">
		                <div class="htpmpro-singleplugin">
		                	<div class="htpmpro-thumb">
		                		<img src="<?php echo HTPMPRO_ROOT_URL . '/assets/images/plugins-image/wcbuilder.png' ?>">
		                	</div>
		                	<div class="htpmpro-content">
			                    <h3><?php esc_html_e( 'WC Builder','htpmpro' );?></h3>
			                    <p><?php esc_html_e( 'WC Builder Pro is a WooCommerce Page Builder which allows you to build Shop, Product Details, Cart, Checkout, My Account and Thank You page without even touching a single line of code!', 'htpmpro' )?></p>
			                    <div class="htpmpro-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/wc-builder-woocoomerce-page-builder-for-wpbakery/#pricing" target="_blank"><?php esc_html_e( 'More Details', 'htpmpro' )?></a>
			                       
			                        <?php htpmpro_plugin_install_button( 'wc-builder/wc-builder.php','wc-builder' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
	        	</div>
			</div>
		</div>
	<?php
}

/**
 * Register option name & group
 * Add section
 * Add fields
 */
add_action( 'admin_init', 'htpmpro_settings_init' );
function htpmpro_settings_init() {
	// reginster option named "htpm_options"
	register_setting( 'options_group_general', 'htpm_options' );

	add_settings_section(
		'section_1',
		'',
		'',
		'options_group_general'
	);

	add_settings_field(
		'htpm_enabled_post_types', // field name
		esc_html__( 'Select Post Types', 'htpmpro' ),
		'htpmpro_enabled_post_types_cb',
		'options_group_general',
		'section_1',
		[
			'label_for' => 'htpm_enabled_post_types',
			'class' => 'htpmpro_row',
		]
	);

	add_settings_field(
		'htpm_list_plugins', // field name
		esc_html__( 'WP Plugins Manager', 'htpmpro' ),
		'htpmpro_list_plugins_cb',
		'options_group_general',
		'section_1',
		[
			'label_for' => 'htpm_list_plugins',
			'class' => 'htpmpro_row',
		]
	);
}

function htpmpro_enabled_post_types_cb( $args ){
	$options = get_option( 'htpm_options' );
	$htpm_enabled_post_types = $options['htpm_enabled_post_types'];

	$cpt_args = array(
	   'public'   => true,
	   '_builtin' => false
	);
	  
	$existing_post_types = array(
		'page' => 'page',
		'post' => 'post',
	);
	$post_types = get_post_types( $cpt_args );
	?>
  	<div>
	  	<select class="htpmpro_select2_active" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][]" multiple="multiple">
  		  	<?php
  		  		foreach ( $post_types as $key => $value ) {
  		  			?>
  		  			<option value="<?php echo esc_attr($key); ?>" <?php selected( in_array($key, $htpm_enabled_post_types), true ); ?>><?php echo esc_html(ucfirst($value)); ?></option>
  		  			<?php
  		  		}
  		  	?>
	  	</select>
	  	<div class="htpmpro_field_desc"><?php echo __('Select the custom post types where you want to disable the plugins. <br> Note: Make sure that, you click on "Save Settings" button so that you get the options for each plugins.') ?></div>
  	</div>
	<?php
}

/**
 * htpmpro_list_plugins_cb callback
 */
function htpmpro_list_plugins_cb( $args ) {
	$options = get_option( 'htpm_options' );
	$htpmpro_list_plugins = $options['htpm_list_plugins'];
	$htpmpro_enabled_post_types = $options['htpm_enabled_post_types'];
 ?>
	<div id="htpmpro_accordion" class="htpmpro_accordion">
		<?php
		$active_plugins = get_option('active_plugins');

		// remove pro plugin from the list
		if (($key = array_search('wp-plugin-manager-pro/plugin-main.php', $active_plugins)) !== false) {
		    unset($active_plugins[$key]);
		}

		$plugin_dir = HTPMPRO_PLUGIN_DIR;

		if($active_plugins):
			foreach($active_plugins as $plugin):
				$idividual_options = isset( $htpmpro_list_plugins[$plugin] ) ? $htpmpro_list_plugins[$plugin] : array( 'condition_list'=>'', 'enable_deactivation'=>Null, 'uri_type'=>'', 'condition_type'=>'', 'device_type'=>'', 'posts'=>'', 'pages'=>'' );
				$plugin_headers = get_plugin_data( $plugin_dir . '/' . $plugin );
			?>
			<h3 class="<?php echo isset( $idividual_options['enable_deactivation'] ) ? 'htpmpro_is_disabled' : ''; ?>"><?php echo esc_html( $plugin_headers['Name'] ); ?></h3>
			<div class="htpmpro_single_accordion" data-htpmpro_uri_type="<?php echo esc_attr( $idividual_options['uri_type'] ? $idividual_options['uri_type'] : 'page'); ?>">

			  	<div class="htpmpro_single_field">
				  	<label><?php echo esc_html__('Disable:', 'htpmpro') ?></label>
					<input type="checkbox" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][enable_deactivation]" value="yes" <?php checked( isset($idividual_options['enable_deactivation']), 1 ); ?>>
				</div>

				<div class="htpmpro_single_field">
				  	<label><?php echo esc_html__( 'Apply rule on:', 'htpmpro' ); ?></label>
				  	<select class="htpmpro_uri_type" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][device_type]">
				  		<option value="all" <?php selected( isset($idividual_options['device_type']) ? $idividual_options['device_type'] : '', 'all' ) ?>><?php echo esc_html__( 'All', 'htpmpro' ) ?></option>
				  		<option value="desktop" <?php selected( isset($idividual_options['device_type']) ? $idividual_options['device_type'] : '', 'desktop' ) ?>><?php echo esc_html__( 'Desktop', 'htpmpro' ) ?></option>
				  		<option value="tablet" <?php selected( isset($idividual_options['device_type']) ? $idividual_options['device_type'] : '', 'tablet' ) ?>><?php echo esc_html__( 'Tablet', 'htpmpro' ) ?></option>
				  		<option value="mobile" <?php selected( isset($idividual_options['device_type']) ? $idividual_options['device_type'] : '', 'mobile' ) ?>><?php echo esc_html__( 'Mobile', 'htpmpro' ) ?></option>
				  	</select>
				</div>

				<div class="htpmpro_single_field">
				  	<label><?php echo esc_html__( 'Condition Type:', 'htpmpro' ); ?></label>
				  	<select class="htpmpro_uri_type" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][condition_type]">
				  		<option value="disable_on_selected" <?php selected( isset($idividual_options['condition_type']) ? $idividual_options['condition_type'] : '', 'disable_on_selected' ) ?>><?php echo esc_html__( 'Disable On Selected', 'htpmpro' ) ?></option>
				  		<option value="enable_on_selected" <?php selected( isset($idividual_options['condition_type']) ? $idividual_options['condition_type'] : '', 'enable_on_selected' ) ?>><?php echo esc_html__( 'Enable On Selected', 'htpmpro' ) ?></option>
				  	</select>
				</div>

				<div class="htpmpro_single_field">
				  	<label><?php echo esc_html__( 'URI Type:', 'htpmpro' ); ?></label>
				  	<select class="htpmpro_uri_type" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][uri_type]">
				  		<option value="page" <?php selected( $idividual_options['uri_type'], 'page' ) ?>><?php echo esc_html__( 'Page', 'htpmpro' ) ?></option>
				  		<option value="post" <?php selected( $idividual_options['uri_type'], 'post' ) ?>><?php echo esc_html__( 'Post', 'htpmpro' ) ?></option>
				  		<option value="page_post" <?php selected( $idividual_options['uri_type'], 'page_post' ) ?>><?php echo esc_html__( 'Post And Pages', 'htpmpro' ) ?></option>
				  		<option value="page_post_cpt" <?php selected( $idividual_options['uri_type'], 'page_post_cpt' ) ?>><?php echo esc_html__( 'Post And Pages & Custom Post Type', 'htpmpro' ) ?></option>
				  		<option value="custom" <?php selected( $idividual_options['uri_type'], 'custom' ) ?>><?php echo esc_html__('Custom', 'htpmpro') ?></option>
				  	</select>
				</div>

				<?php if($htpmpro_enabled_post_types && is_array($htpmpro_enabled_post_types)): ?>
				<div class="htpmpro_single_field htpmpro_none cpt_posts htpmpro_selected_page_post_cpt">
				  	<label><?php echo esc_html__( 'Select Custom Post Types:', 'htpmpro' ) ?></label>
				  	<div>
			  		<?php
			  			
			  			$has_cpt = false;
			  			$cpt_args = array(
			  			   'public'   => true,
			  			   '_builtin' => false
			  			);
			  			  
			  			$existing_post_types = array(
			  				'page' => 'page',
			  				'post' => 'post',
			  			);

			  			$post_types = get_post_types( $cpt_args );

			  			$post_types_merged = array_merge($existing_post_types, $htpmpro_enabled_post_types);

			  			$selected_post_types = isset($idividual_options['post_types']) && $idividual_options['post_types'] ? $idividual_options['post_types'] : array();

			  			foreach($post_types_merged as $post_type){
			  				$count_posts = wp_count_posts( $post_type );
			  				if( $count_posts->publish ){
			  					$has_cpt = true;
			  					$post_type_key_plural = $post_type. 's';
			  				?>
				  		<input type="checkbox" id="<?php echo esc_attr($post_type) ?>" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][post_types][]" value="<?php echo esc_attr($post_type) ?>" <?php checked( in_array($post_type, $selected_post_types), true ); ?>>
				  		<label for="<?php echo esc_attr($post_type) ?>"><?php echo esc_attr(ucfirst($post_type)) ?></label>
				  				<?php
				  				}
				  			} // foreach
				  		?>
				  		<?php
				  			if( !$has_cpt ){
				  				echo esc_html__('Either you don\'t have any custom post types OR you haven\'t created any posts for your existing custom post types.', 'whols');
				  			}
				  		?>
				  	</div>
				</div>
				<?php endif; // htpmpro_enabled_post_types ?>

				<div class="htpmpro_single_field htpmpro_none cpt_posts htpmpro_selected_page_checkboxes <?php echo in_array('page', $selected_post_types) ? '': 'htpmpro_none'; ?>" data-dependent_on="page">
				  	<label><?php echo esc_html__( 'Select Pages:', 'htpmpro' ) ?></label>
				  	<div>
					  	<select class="htpmpro_select2_active" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][pages][]" multiple="multiple">
			  	  		  	<?php
			  	  		  		$selected_pages = isset($idividual_options['pages']) && $idividual_options['pages'] ? $idividual_options['pages'] : array();

			  	  		  		$pages = get_pages();
			  	  		  		foreach ( $pages as $key => $page ) {
			  	  		  			$option_value = esc_attr($page->ID) .','. esc_url(get_page_link( $page->ID ));
			  	  		  			$is_selected = in_array($option_value,  $selected_pages);
			  	  		  			?>
			  	  		  			<option value="<?php echo esc_attr($option_value); ?>" <?php selected($is_selected , true ) ?>><?php echo esc_html($page->post_title);  ?></option>
			  	  		  			<?php
			  	  		  			$option_page_id = false;
			  	  		  		}
			  	  		  	?>
					  	</select>
				  	</div>
				</div>
				
				<div class="htpmpro_single_field htpmpro_none cpt_posts htpmpro_selected_post_checkboxes <?php echo in_array('post', $selected_post_types) ? '': 'htpmpro_none'; ?>" data-dependent_on="post">
				  	<label><?php echo esc_html__( 'Select Posts:', 'htpmpro' ) ?></label>
				  	<div>
	  				  	<select class="htpmpro_select2_active" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][posts][]" multiple="multiple">
	  		  	  		  	<?php
	  		  	  		  		$selected_posts = isset($idividual_options['posts']) && $idividual_options['posts'] ? $idividual_options['posts'] : array();

	  		  	  		  		$posts = get_posts(array(
	  		  	  		  			'numberposts' => '-1'
	  		  	  		  		));
	  		  	  		  		foreach ( $posts as $key => $post ) {
	  		  	  		  			$option_value = esc_attr($post->ID) .','. esc_url(get_permalink( $post->ID ));
	  		  	  		  			$is_selected = in_array($option_value,  $selected_posts);
	  		  	  		  			?>
	  		  	  		  			<option value="<?php echo esc_attr($option_value); ?>" <?php selected($is_selected, true ) ?>><?php echo esc_html($post->post_title);  ?></option>
	  		  	  		  			<?php
	  		  	  		  		}
	  		  	  		  	?>
	  				  	</select>
				  	</div>
				</div>

				<?php
					foreach($post_types as $post_type){
						$count_posts = wp_count_posts( $post_type );
						if( $count_posts->publish ){
							$post_type_key_plural     = $post_type. 's';
							$selected_post_type_posts = isset($idividual_options[$post_type_key_plural]) && $idividual_options[$post_type_key_plural] ? $idividual_options[$post_type_key_plural] : array();
						?>
						<div class="htpmpro_single_field htpmpro_none cpt_posts htpmpro_selected_<?php echo esc_attr($post_type) ?>"  data-dependent_on="<?php echo esc_attr($post_type) ?>" style="<?php echo in_array($post_type,$selected_post_types) ? '': 'display: none;'; ?>">
						  	<label>
						  		<?php echo esc_html__( 'Select '. $post_type_key_plural .':', 'htpmpro' ) ?>
						  			
						  	</label>
						  	<div>
			  				  	<select class="htpmpro_select2_active" name="htpm_options[<?php echo esc_attr( $args['label_for'] ); ?>][<?php echo esc_attr($plugin) ?>][<?php echo esc_attr($post_type_key_plural) ?>][]" multiple="multiple">
			  		  	  		  	<?php
			  		  	  		  		$posts = get_posts(array(
			  		  	  		  			'numberposts' => '150',
			  		  	  		  			'post_type' => $post_type
			  		  	  		  		));
			  		  	  		  		foreach ( $posts as $key => $post ) {
			  		  	  		  			$option_value = esc_attr($post->ID) .','. esc_url(get_permalink( $post->ID ));
			  		  	  		  			$is_selected = in_array($option_value,  $selected_post_type_posts);
			  		  	  		  			?>
			  		  	  		  			<option value="<?php echo esc_attr($option_value); ?>" <?php selected($is_selected, true ) ?>><?php echo esc_html($post->post_title);  ?></option>
			  		  	  		  			<?php
			  		  	  		  		}
			  		  	  		  	?>
			  				  	</select>
						  	</div>
						</div>
						<?php
						}
						$selected_post_type_posts = array();
					} // foreach
				?>

			  	<table id="htpmprorepeatable-fieldset" class="htpmpro_repeater" width="100%">
		            <thead>
		                <tr>
		                    <th><?php echo esc_html__( 'URI Condition', 'htpmpro' ) ?></th>
		                    <th><?php echo esc_html__( 'Value', 'htpmpro' ); ?></th>
		                    <th><?php echo esc_html__( 'Action', 'htpmpro' ); ?></th>
		                </tr>
		            </thead>
		            <tbody>
		            	<?php 
		            	$condition_list = array();
		            	$condition_list = $idividual_options['condition_list'];
		            	if( !$condition_list):
		            	?>
		            		<tr>
		            	        <td>
		            	        	<select name="htpm_options[htpm_list_plugins][<?php echo esc_attr( $plugin ) ?>][condition_list][name][]">
		            	        		<option value="uri_equals"><?php echo esc_html__( 'URI Equals', 'htpmpro' ) ?></option>
		            	        		<option value="uri_not_equals"><?php echo esc_html__( 'URI Not Equals', 'htpmpro' ) ?></option>
		            	        		<option value="uri_contains"><?php echo esc_html__( 'URI Contains', 'htpmpro' ) ?></option>
		            	        		<option value="uri_not_contains"><?php echo esc_html__( 'URI Not Contains', 'htpmpro' ) ?></option>
		            	        	</select>
		            	        </td>
		            	        <td>
		            	            <input class="widefat" type="text" placeholder="<?php echo esc_html__('E.g: http://example.com/contact-us/ you can use \'contact-us\'', 'htpmpro'); ?>" name="htpm_options[htpm_list_plugins][<?php echo esc_attr($plugin) ?>][condition_list][value][]" value="">
		            	        </td>
		            	        <td>
		            	            <a class="button htpmpro-remove-row" href="#"><?php echo esc_html__('Remove', 'htpmpro') ?></a>
		            	            <a class="button htpmpro-add-row" href="#"><?php echo esc_html__( 'Clone', 'htpmpro' ) ?></a>
		            	        </td>
		            	    </tr>
		            	<?php
		            	endif;

		            	if($condition_list):
		            	for($i = 0; $i < count($condition_list['name']); $i++ ):
		            		if($condition_list['name'][$i]):
		            	?>
		            	<tr>
		                    <td>
		                    	<select name="htpm_options[htpm_list_plugins][<?php echo esc_attr( $plugin ) ?>][condition_list][name][]">
		                    		<option value="uri_equals" <?php selected( $condition_list['name'][$i], 'uri_equals') ?>><?php echo esc_html__( 'URI Equals', 'htpmpro' ) ?></option>
		                    		<option value="uri_not_equals" <?php selected( $condition_list['name'][$i], 'uri_not_equals') ?>><?php echo esc_html__( 'URI Not Equals', 'htpmpro' ) ?></option>
		                    		<option value="uri_contains" <?php selected( $condition_list['name'][$i], 'uri_contains') ?>><?php echo esc_html__( 'URI Contains', 'htpmpro' ) ?></option>
		                    		<option value="uri_not_contains" <?php selected( $condition_list['name'][$i], 'uri_not_contains') ?>><?php echo esc_html__( 'URI Not Contains', 'htpmpro' ) ?></option>
		                    	</select>
		                    </td>
		                    <td>
		                        <input class="widefat" type="text" placeholder="<?php echo esc_html__('E.g: http://example.com/contact-us/ you can use \'contact-us\'', 'htpmpro'); ?>'" name="htpm_options[htpm_list_plugins][<?php echo esc_attr($plugin) ?>][condition_list][value][]" value="<?php echo esc_attr($condition_list['value'][$i]); ?>">
		                    </td>
		                    <td>
		                        <a class="button htpmpro-remove-row" href="#"><?php echo esc_html__('Remove', 'htpmpro') ?></a>
		                        <a class="button htpmpro-add-row" href="#"><?php echo esc_html__( 'Clone', 'htpmpro' ) ?></a>
		                    </td>
		                </tr>
		            	<?php
		            		endif;
		            	endfor;
		            	endif;
		            	?>
		            </tbody>
	        	</table>
		        <table class="screen-reader-text">
		        	<!-- empty hidden one for jQuery -->
		        	<tr class="htpmpro-empty-row screen-reader-text">
		        	    <td>
		        	        <input type="text" placeholder="Enter Title" name="htpm_options[htpmpro_list_plugins][<?php echo esc_attr($plugin) ?>][condition_list][name][]">
		        	    </td>
		        	    <td>
		        	        <input type="text" placeholder="Enter Price" name="htpm_options[htpmpro_list_plugins][<?php echo esc_attr($plugin) ?>][condition_list][value][]">
		        	    </td>
		        	    <td>
		        	     	<a class="button htpmpro-remove-row" href="#"><?php echo esc_html__('Remove', 'htpmpro') ?></a>
		        	     	<a class="button htpmpro-add-row" href="#"><?php echo esc_html__( 'Add Another', 'htpmpro' ) ?></a>
		        	    </td>
		        	</tr>
		        </table>
			</div>
			<?php
			endforeach;
		endif;
		?>
	</div> <!-- .htpmpro_accordion -->

	<script type="text/javascript">
	    jQuery(document).ready(function() {
	        jQuery(".htpmpro_selected_page_post_cpt input").click( function(){
	           if( jQuery(this).is(':checked') ){
	           	<?php
	           		foreach($post_types_merged as $post_type):
	           			$count_posts = wp_count_posts( $post_type );
	           			if( $count_posts->publish ):
	           	?>
	           		if(this.value == '<?php echo esc_js($post_type); ?>'){
	           			jQuery(this).parent().parent().parent().find(`[data-dependent_on='${this.value}']`).css('display', 'flex');
	           		}

	           	<?php  endif; endforeach; ?>
	           } else {
	           		<?php
	           			foreach($post_types_merged as $post_type):
	           				$count_posts = wp_count_posts( $post_type );
	           				if( $count_posts->publish ):
	           		?>
	           			if(this.value == '<?php echo esc_js($post_type); ?>'){
	           				jQuery(this).parent().parent().parent().find(`[data-dependent_on='${this.value}']`).hide();
	           			}
	           		<?php endif; endforeach; ?>
	           }
	        });
	    });
	</script>
 <?php
}