<?php


function cloudfw_font_icons_list(){
	$icons = array();
	return apply_filters( 'cloudfw_font_icons', $icons );
}

/**
 *	Get All Posts
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_all_pages(){
	if ( cloudfw_vc_isset( __FUNCTION__, 'cache' ) ) {

		return cloudfw_vc_get( __FUNCTION__, 'cache' );

	} else {

		$defaults = array(
			'depth'                 => 0,
			'child_of'              => 0,
			'name'                  => 'page_id',
			'id'                    => '',
			'post_status'           => 'publish,private,draft',
		);

		extract( $defaults, EXTR_SKIP );
		$pages = get_pages( $defaults );

		$out = array();
		$out_loop = array();
		$out['NULL'] = '- '. __('Default','envision') .' -';

		if ( ! empty($pages) ) {
			$out_loop = cloudfw_walk_page_dropdown_tree( $pages, $depth, $defaults );
		}

		$out = $out + (array) $out_loop;

		return cloudfw_vc_set( __FUNCTION__, 'cache', $out );

	}

}


/**
 *	Get All Authors
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_authors( $args = array() ){
	if ( cloudfw_vc_isset( __FUNCTION__, 'cache' ) ) {

		return cloudfw_vc_get( __FUNCTION__, 'cache' );

	} else {

		$defaults = array(
			'depth'                 => 0,
			'child_of'              => 0,
			'name'                  => 'page_id',
			'id'                    => '',
		);

		$out = array();
		$defaults = array(
			'orderby' => 'name', 'order' => 'ASC', 'number' => '',
			'optioncount' => false, 'exclude' => '', 'include' => '',
			'blog_id' => $GLOBALS['blog_id'],
			'who' => 'authors',
			'show_fullname'	=> true,
		);

		$args = wp_parse_args( $args, $defaults );
		extract( $args, EXTR_SKIP );

		$return = '';

		$query_args = wp_array_slice_assoc( $args, array( 'blog_id', 'include', 'exclude', 'orderby', 'order', 'who' ) );
		$query_args['fields'] = 'ids';
		$authors = get_users( $query_args );

		foreach ( $authors as $author_id ) {
			$author = get_userdata( $author_id );

			$link = '';

			if ( $show_fullname && $author->first_name && $author->last_name )
				$name = "$author->first_name $author->last_name";
			else
				$name = $author->display_name;

			$name = trim($name);
			if ( empty($name) ) {
				$name = $author->display_name;
			}

			$out[ $author->ID ] = $name;

		}

		return cloudfw_vc_set( __FUNCTION__, 'cache', $out );

	}

}


/**
 * Retrieve HTML dropdown (select) content for page list.
 *
 * @uses Walker_PageDropdown to create HTML dropdown content.
 * @since 2.1.0
 * @see Walker_PageDropdown::walk() for parameters and return description.
 */
function cloudfw_walk_page_dropdown_tree() {
	$args = func_get_args();
	$walker = new CloudFw_Walker_PageDropdown;
	return call_user_func_array( array($walker, 'walk'), $args );
}

/**
 * Create HTML dropdown list of pages.
 *
 * @package WordPress
 * @since 2.1.0
 * @uses Walker
 */
class CloudFw_Walker_PageDropdown extends Walker {
	/**
	 * @see Walker::$tree_type
	 * @since 2.1.0
	 * @var string
	 */
	var $tree_type = 'page';

	/**
	 * @see Walker::$db_fields
	 * @since 2.1.0
	 * @todo Decouple this
	 * @var array
	 */
	var $db_fields = array ('parent' => 'post_parent', 'id' => 'ID');

	/**
	 * @see Walker::start_el()
	 * @since 2.1.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $page Page data object.
	 * @param int $depth Depth of page in reference to parent pages. Used for padding.
	 * @param array $args Uses 'selected' argument for selected page to set selected HTML attribute for option element.
	 * @param int $id
	 */
	function start_el( &$output, $page, $depth = 0, $args = array(), $id = 0 ) {
		$pad = str_repeat('&nbsp;', $depth * 3);


		$output[ ''.$page->ID.'' ] = $pad . esc_attr( $page->post_title ) . ( $page->post_status != 'publish' ? ' (' . $page->post_status . ')' : '' );
	}


	/**
	 * Display array of elements hierarchically.
	 *
	 * Does not assume any existing order of elements.
	 *
	 * $max_depth = -1 means flatly display every element.
	 * $max_depth = 0 means display all levels.
	 * $max_depth > 0 specifies the number of display levels.
	 *
	 * @since 2.1.0
	 *
	 * @param array $elements  An array of elements.
	 * @param int   $max_depth The maximum hierarchical depth.
	 * @return string The hierarchical item output.
	 */
	public function walk( $elements, $max_depth, ...$args ) {
		$args = array_slice(func_get_args(), 2);
		$output = array();

		//invalid parameter or nothing to walk
		if ( $max_depth < -1 || empty( $elements ) ) {
			return $output;
		}

		$parent_field = $this->db_fields['parent'];

		// flat display
		if ( -1 == $max_depth ) {
			$empty_array = array();
			foreach ( $elements as $e )
				$this->display_element( $e, $empty_array, 1, 0, $args, $output );
			return $output;
		}

		/*
		 * Need to display in hierarchical order.
		 * Separate elements into two buckets: top level and children elements.
		 * Children_elements is two dimensional array, eg.
		 * Children_elements[10][] contains all sub-elements whose parent is 10.
		 */
		$top_level_elements = array();
		$children_elements  = array();
		foreach ( $elements as $e) {
			if ( empty( $e->$parent_field ) )
				$top_level_elements[] = $e;
			else
				$children_elements[ $e->$parent_field ][] = $e;
		}

		/*
		 * When none of the elements is top level.
		 * Assume the first one must be root of the sub elements.
		 */
		if ( empty($top_level_elements) ) {

			$first = array_slice( $elements, 0, 1 );
			$root = $first[0];

			$top_level_elements = array();
			$children_elements  = array();
			foreach ( $elements as $e) {
				if ( $root->$parent_field == $e->$parent_field )
					$top_level_elements[] = $e;
				else
					$children_elements[ $e->$parent_field ][] = $e;
			}
		}

		foreach ( $top_level_elements as $e )
			$this->display_element( $e, $children_elements, $max_depth, 0, $args, $output );

		/*
		 * If we are displaying all levels, and remaining children_elements is not empty,
		 * then we got orphans, which should be displayed regardless.
		 */
		if ( ( $max_depth == 0 ) && count( $children_elements ) > 0 ) {
			$empty_array = array();
			foreach ( $children_elements as $orphans )
				foreach ( $orphans as $op )
					$this->display_element( $op, $empty_array, 1, 0, $args, $output );
		 }

		 return $output;
	}
}


/**
 *	Prepare Custom Sidebars Array
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_custom_sidebars( $placeholder = true, $placeholder_value = '', $placeholder_title = '' ){
	$out = array();

	if ( $placeholder ) {
		$placeholder_value = !empty($placeholder_value) ? $placeholder_value : 'NULL';
		$placeholder_title = !empty($placeholder_title) ? $placeholder_title : __('Default','envision');

		$out[ $placeholder_value ] = $placeholder_title;
	}

	if ( cloudfw_vc_isset( __FUNCTION__, 'cache' ) ) {
		$out = array_merge($out, (array)cloudfw_vc_get( __FUNCTION__, 'cache' ));

	} else {
		if ( is_array( $GLOBALS['wp_registered_sidebars'] ) ) {
			$default_sidebars = array();
			foreach( $GLOBALS['wp_registered_sidebars'] as $sidebar_id => $sidebar_data )
				if ( cloudfw_custom_sidebar_exists( $sidebar_id ) )
					$sidebars[__('Custom Sidebars','envision')][ $sidebar_data['id'] ] = $sidebar_data['name'];
				else
					$sidebars[__('Theme Sidebars','envision')][ $sidebar_data['id'] ] = $sidebar_data['name'];

			$out = array_merge($out, (array)cloudfw_vc_set( __FUNCTION__, 'cache', $sidebars ));
		}
	}

	return $out;
}

/**
 *	Prepare Custom Sidebars Array
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_page_templates(){
	if ( cloudfw_vc_isset( __FUNCTION__, 'cache' ) )
		return cloudfw_vc_get( __FUNCTION__, 'cache' );

	$out = array();
	$out['NULL'] = '-';
	$out['default'] = __('Default','envision');

	/** Get All Templates  */
	$templates = get_page_templates();

	foreach ( $templates as $template => $template_id ) {
		$out[$template_id] = $template;
	}

	return cloudfw_vc_set( __FUNCTION__, 'cache', $out );
}

/**
 *	Prepare Topbar Widget List
 *
 *	@since 1.0
 */
function cloudfw_admin_get_topbar_widget_list(){
	$out = array();
	$out['NULL'] = '';

	$class = new CloudFw_TopBar_Widgets;
	$out = array_merge( $out, (array) $class->widget_list() );

	return $out;
}

/**
 *	Prepare Menubar Widget List
 *
 *	@since 1.0
 */
function cloudfw_admin_get_menubar_widget_list(){
	$out = array();
	$out['NULL'] = '';

	$class = new CloudFw_MenuBar_Widgets;
	$out = array_merge( $out, (array) $class->widget_list() );

	return $out;
}


/**
 *	Prepare Socialbar Services
 *
 *	@since 1.0
 */
function cloudfw_admin_get_socialbar_services(){
	$out = array();
	if ( function_exists('cloudfw_socialbar_services') )
		foreach ( (array) cloudfw_socialbar_services() as $service_id => $service )
			$out[ $service_id ] = $service['title'];

	return $out;
}


/**
 *	Prepare List of All Menus
 *
 *	@since 1.0
 */
function cloudfw_admin_get_all_menus(){
	$out = array();
	$out['NULL'] = '';

	$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
	foreach ( (array) $menus as $menu )
		$out[ $menu->term_id ] = $menu->name;

	return $out;
}


/**
 *	Prepare List of All Menus
 *
 *	@since 1.0
 */
function cloudfw_admin_get_visibility_options(){
	$out = array();
	$out['NULL'] = __('All Devices','envision');

	$out['desktop']        = __('Only Widescreen Devices','envision');
	$out['desktop-tablet'] = __('Widescreen Devices & Tablets','envision');
	$out['tablet']         = __('Only Tablets','envision');
	$out['tablet-phones']  = __('Tablets & Phones','envision');
	$out['phone']          = __('Only Phones','envision');

	return $out;
}

/**
 *	Text Decoration Options Array
 *
 *	@since 1.0
 */
function cloudfw_admin_array_text_decorations(){
	$out['NULL']         = __('Default','envision');
	$out['none']         = __('None','envision');
	$out['underline']    = __('Underline','envision');
	$out['overline']     = __('Overline','envision');
	$out['line-through'] = __('Line-through','envision');
	return $out;
}

/**
 *	Background Styles
 *
 *	@since 1.0
 */
function cloudfw_admin_array_bg_styles(){
	$out['NULL']     =	__('Auto','envision');
	$out['cover']    =	__('Cover','envision');
	$out['repeat']   =	__('Repeat','envision');
	$out['repeat-x'] =	__('Repeat Horizontal','envision');
	$out['repeat-y'] =	__('Repeat Vertical','envision');
	$out['no-repeat'] =	__('No Repeat','envision');

	return $out;
}

/**
 *	Columns
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_columns() {
	$out = array();
	$out['NULL']   = __('Default','envision');
	$out['1']      = __('1 Column','envision');
	$out['2']      = sprintf(__('%d Columns','envision'), 2);
	$out['3']      = sprintf(__('%d Columns','envision'), 3);
	$out['4']      = sprintf(__('%d Columns','envision'), 4);
	$out['6']      = sprintf(__('%d Columns','envision'), 6);
	return apply_filters('cloudfw_options_columns', $out);
}


/**
 *	Aspect Ratio
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_aspect_ratio() {
	$out = array();
	$out['NULL']   = __('Default','envision');
	$out['21:9']   = '21:9';
	$out['16:9']   = '16:9';
	$out['4:3']    = '4:3';
	$out['1:1']    = '1:1 (Square)';
	$out['3:4']    = '3:4';
	$out['9:16']   = '9:16';
	$out['9:21']   = '9:21';
	$out['original']   = __('Original','envision');

	return $out;
}

/**
 *	Link Targets
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_link_targets() {
	$out = array();
	$out['NULL']   = __('Default','envision');
	$out['_blank'] = __('Open on new page','envision');

	return $out;
}

/**
 *	Text Aligns
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_text_aligns() {
	$out = array();
	$out['NULL']   = __('Default','envision');
	$out['left']   = __('Left','envision');
	$out['center'] = __('Center','envision');
	$out['right']  = __('Right','envision');

	return $out;
}

/**
 *	Background Positions
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_background_positions() {
	$out = array();
	$out['NULL']          = __('Default','envision');
	$out['50% 50%']       = __('Center, Center','envision');
	$out['0 50%']         = __('Center, Left','envision');
	$out['100% 50%']      = __('Center, Right','envision');
	$out['0 0']           = __('Top, Left','envision');
	$out['100% 0']        = __('Top, Right','envision');
	$out['50% 0']         = __('Top, Center','envision');
	$out['0 100%']        = __('Bottom, Left','envision');
	$out['100% 100%']     = __('Bottom, Right','envision');
	$out['50% 100%']      = __('Bottom, Center','envision');

	return $out;
}

/**
 *	Background Attachments
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_background_attachments() {
	$out = array();
	$out['NULL']          = __('Default','envision');
	$out['scroll']        = __('Scroll','envision');
	$out['fixed']         = __('Fixed','envision');

	return $out;
}

/**
 *	Background Sizes
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_background_sizes() {
	$out = array();
	$out['NULL']          = __('Auto','envision');
	$out['cover']         = __('Cover','envision');
	$out['contain']        = __('Contain','envision');

	return $out;
}

/**
 *	Orderby Values
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_order_by() {
	$out               = array();
	$out['NULL']       = __('Default','envision');
	$out['menu_order'] = __('Menu Order','envision');
	$out['title']      = __('Title','envision');
	$out['date']       = __('Date','envision');
	$out['modified']   = __('Last Modified Date','envision');
	$out['ID']         = __('Post ID','envision');
	$out['parent']     = __('Parent Post/Page ID','envision');
	$out['rand']       = __('Random','envision');

	return $out;
}

/**
 * Order Values
 *
 * @return array
 */
function cloudfw_admin_loop_order() {
	$out               = array();
	$out['NULL']       = __('Default','envision');
	$out['ASC']        = __('ASC - Ascending order from lowest to highest values','envision');
	$out['DESC']       = __('DESC - descending order from highest to lowest values','envision');

	return $out;
}

/**
 *	Content Layouts
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_content_layouts() {
	$out = array();
	$out['NULL']     = __('Normal','envision');
	$out['carousel'] = __('Carousel Layout','envision');
	$out['masonry']  = __('Masonry Layout','envision');

	return $out;
}

/**
 *	CSS Overflow Options
 *
 *	@since 1.0
 */
function cloudfw_admin_loop_overflow() {
	$out = array();
	$out['NULL']    = __('Default','envision');
	$out['visible'] = __('Visible','envision');
	$out['hidden']  = __('Hidden','envision');

	return $out;
}
