<?php
/**
 * The Footer for the theme
 *
 * The source codes: "includes/theme/theme.page_generator.php" : footer
 *
 * @author Orkun GURSEL (help@wptation.com)
 *
 * @package WordPress
 * @subpackage CloudFw
 */

defined( 'ABSPATH' ) || exit;

$footer_widgets = cloudfw_check_onoff('footer', 'widgetized_enable');
$footer_widgets_row1_enable = cloudfw_check_onoff('footer', 'row1_enable');
$footer_widgets_row2_enable = cloudfw_check_onoff('footer', 'row2_enable');

$footer_bottom = cloudfw_check_onoff('footer_bottom', 'enable');
$footer_bottom_text = do_shortcode( cloudfw_translate('text', 'footer_bottom') );
$reverse_footer_widgets = is_rtl() && ! wp_is_mobile();
$disable_footer = cloudfw( 'get', 'disable_footer' );
$is_display_footer = ! isset( $disable_footer ) || $disable_footer !== true;

$footer_widgets_row1_html = '';
if ( $is_display_footer && $footer_widgets && $footer_widgets_row1_enable ) {
	ob_start();

	$footer_widgets_row1 = cloudfw_get_option('footer', 'row1');
	$footer_widgets_row1 = explode('/', $footer_widgets_row1);

	if ( $reverse_footer_widgets && is_array( $footer_widgets_row1 ) ) {
		$footer_widgets_row1 = array_reverse( $footer_widgets_row1 );
	}
	if ( is_array($footer_widgets_row1) ) {
		foreach ($footer_widgets_row1 as $number => $column_class) {
			if ( $reverse_footer_widgets ) {
				$column = count($footer_widgets_row1)-($number);
			} else {
				$column = ++$number;
			}

			$sidebar_slug = cloudfw_get_option('footer', 'widget_column_row1_' . $column);

			if ( is_active_sidebar( $sidebar_slug ) ) : ?>
				<aside class="widget-area <?php echo esc_attr( $column_class ); ?>">
					<?php dynamic_sidebar( $sidebar_slug );?>
				</aside>
			<?php
			endif;
		}
		$footer_widgets_row1_html = ob_get_clean();
	}

}

$footer_widgets_row2_html = '';
if ( $is_display_footer && $footer_widgets && $footer_widgets_row2_enable ) {
	ob_start();

	$footer_widgets_row2 = cloudfw_get_option('footer', 'row2');
	$footer_widgets_row2 = explode('/', $footer_widgets_row2);

	if ( $reverse_footer_widgets && is_array( $footer_widgets_row2 ) ) {
		$footer_widgets_row2 = array_reverse( $footer_widgets_row2 );
	}
	if ( is_array($footer_widgets_row2) ) {
		foreach ($footer_widgets_row2 as $number => $column_class) {
			if ( $reverse_footer_widgets ) {
				$column = count($footer_widgets_row2)-($number);
			} else {
				$column = ++$number;
			}

			$sidebar_slug = cloudfw_get_option('footer', 'widget_column_row2_' . $column);

			if ( is_active_sidebar( $sidebar_slug ) ) : ?>
				<aside class="widget-area <?php echo esc_attr( $column_class ); ?>">
					<?php dynamic_sidebar( $sidebar_slug );?>
				</aside>
			<?php
			endif;
		}
	}

	$footer_widgets_row2_html = ob_get_clean();

	if( ! empty( $footer_widgets_row2_html ) && ! empty( $footer_widgets_row1_html ) ){
		$footer_widgets_row2_html = '<div class="footer-widgets-row-separator ui--footer-seperator-color"></div>' . $footer_widgets_row2_html;
	}
}

cloudfw( 'footer' );

if ( $is_display_footer ): ?>

	<footer class="ui--footer ui-dark">

		<?php
			if ( $footer_widgets_row1_html || $footer_widgets_row2_html ):
		?>
		<div id="footer-widgets">
			<div class="container">

			<?php if ( $footer_widgets_row1_html ) { ?>
				<div id="footer-widgets-row1">
					<div class="ui-row row">
						<?php echo cloudfw_escape( $footer_widgets_row1_html ); ?>
					</div>
				</div>
			<?php } ?>

			<?php if ( $footer_widgets_row2_html ) { ?>
				<div id="footer-widgets-row1">
					<div class="ui-row row">
						<?php echo cloudfw_escape( $footer_widgets_row2_html ); ?>
					</div>
				</div>
			<?php } ?>

			</div>
		</div>

		<?php
			endif;
		?>

		<?php

		if( $footer_bottom && ( ! empty( $footer_bottom_text ) || has_nav_menu( 'footer' ) ) ) {
			/** Get options for the footer bottom bar */
			switch (cloudfw_get_option( 'footer_bottom', 'layout' )) {
				default:
				case 'text/menu':
					$footer_bottom_classes = array(
						'text'       => 'pull-left',
						'navigation' => 'pull-right',
						'main'		 => '',
					);
					break;

				case 'menu/text':
					$footer_bottom_classes = array(
						'text'       => 'pull-right',
						'navigation' => 'pull-left',
						'main'		 => '',
					);
					break;

				case 'vertical':
					$footer_bottom_classes = array(
						'text'       => '',
						'navigation' => '',
						'main'		 => 'layout--centered',
					);
					break;
			}
		?>
			<div id="footer-bottom" class="<?php echo esc_attr($footer_bottom_classes['main']); ?>">
				<div class="container">
					<?php if( !empty($footer_bottom_text) ) { ?>
						<div id="footer-texts" class="<?php echo esc_attr($footer_bottom_classes['text']); ?>"><?php echo wp_kses_post($footer_bottom_text); ?></div>
					<?php } ?>

					<?php
						wp_nav_menu( array(
							'fallback_cb'           => '__return_false',
							'theme_location'        => 'footer',
							'container'             => 'div',
							'container_id'          => 'footer-navigation',
							'container_class'       => $footer_bottom_classes['navigation'],
							'menu_class'            => 'clearfix unstyled-all',
							'menu_id'               => '',
							'before'                => '',
							'after'                 => '</li><li class="ui--separator"> / ',
							'link_before'           => '',
							'link_after'            => '',
							'caret'                 => '',
							'sub_level_caret_right' => '',
							'sub_level_caret_left'  => '',
							'depth'                 => 1,
							'walker'                => cloudfw_conditional_menu_class(),
						));
					?>
				</div>
			</div>
		<?php } ?>

	</footer>

	<?php endif; ?>

	<?php do_action( 'cloudfw_append_main_container' ); ?>
	</div><!-- /#page-wrap -->
</div><!-- /#main-container -->

<?php
	ob_start();
	do_action('cloudfw_side_panel');
	$side_panel_content = ob_get_contents(); ob_end_clean();

	if ( ! empty( $side_panel_content ) ) {
?>
	<div id="side-panel" class="ui-row" style="display: none;">
		<?php echo do_shortcode( $side_panel_content ); ?>
		<?php if ( cloudfw_check_onoff( 'side_panel', 'close_button' ) ) {

			echo cloudfw_create_button(array(
				'id'	   => 'ui--side-panel-close-button',
				'link'	   => 'javascript:;',
				'color'    => cloudfw_get_option( 'side_panel_1', 'close_button_style', 'btn-primary' ),
				'block'    => false,
				'lightbox' => false,
			), '<i class="ui--icon fontawesome-remove" style="font-size: 16px;  width: 18px;  height: 18px;"></i>');

		} ?>
	</div>
<?php } ?>

</div><!-- /#side-panel-pusher -->

<?php wp_footer(); ?>
</body>
<?php do_action( 'cloudfw_after_body' ); ?>
</html>

<?php
do_action( 'cloudfw_page_end' );
