<?php
/**
 * Checkout coupon form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.4
 */

defined( 'ABSPATH' ) || exit;

if ( ! wc_coupons_enabled() ) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="woocommerce-form-coupon-toggle">
	<?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', __( 'Have a coupon?', 'envision' ) . ' <a href="#" class="showcoupon">' . __( 'Click here to enter your code', 'envision' ) . '</a>' ), 'notice' ); ?>
</div>
<form method="post" class="checkout_coupon form-horizontal ui-row ui--box" style="display:none; margin: -30px 0 30px;">

	<div class="form-elements">
		<div class="ui-row row">
			<div class="span12">

				<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'envision' ); ?></p>

				<div class="control-group">
					<div class="controls">
						<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'envision' ); ?>" id="coupon_code" value="" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="form-actions clearfix ui--gradient ui--gradient-grey">
		<div class="pull-right"><button type="submit" class="btn btn-primary" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'envision' ); ?>" ><?php esc_html_e( 'Apply coupon', 'envision' ); ?></button></div>
	</div>
</form>

