<?php
/*
 * Plugin Name: Icon Boxes
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 * Shortcode:
 * Attributes:
 */

cloudfw_register_shortcode( 'CloudFw_Shortcode_Icon_Boxes', 'text_block', 'style', 25 );
if ( ! class_exists('CloudFw_Shortcode_Icon_Boxes') ) {
	class CloudFw_Shortcode_Icon_Boxes extends CloudFw_Shortcodes {

		function get_called_class(){ return get_class($this); }


		/** Add the shortcode to the composer */
		function composer(){
			return array(
				'composer'		=> true,
				'ajax'			=> true,
				'icon'			=> 'icon-box',
				'group'			=> 'composer_widgets',
				'line'			=> 190,
				'options'		=> array(
					'title'				=> __('Text Block + Icon','envision-core'),
					'sync_title'		=> 'icon_box_title',
					'column'			=> '1/1',
					'allow_columns'		=> true,
				)
			);
		}

		/** Run */
		function shortcode( $atts = array(), $content =  NULL, $case = NULL ) {
			extract(shortcode_atts(array(
				"icon"             => NULL,
				"title"            => NULL,
				"title_color"      => NULL,
				"link"             => NULL,
				"link_icon"        => false,
				"target"           => NULL,
				"lightbox"         => 'FALSE',
				"position"         => NULL,
				"title_position"   => 'left',
				"content_align"    => 'left',
				"format"           => 'FALSE',
				"color"            => '',
				"tag"              => 'h3',
				"style_img"        => '',
				"style_title"      => '',

				'effect_icon'      => '',
				'effect_title'     => 'fx--no-effect',
				'effect_text'      => 'fx--no-effect',

				"margin_top"       => '',
				"margin_bottom"    => '',
			), _check_onoff_false($atts)));

			$parts = array(
				"icon"	=> "",
				"title"	=> "",
				"text"	=> "",
			);

			/**
			 *	Link
			 */
			if ( !empty($link) ) {
				$link = cloudfw_get_page_link($link);

				if (!$link) {
					$link = "#";
				} elseif( $link[0] == '/' ) {
					$link = cloudfw_home_url() . $link;
				}

				$title_element = array();
				$title_element[0] = '';
				$title_element[1] = '';

				$title_element[0] .= '<a href="'. $link .'"';

				if ( $lightbox ) {
					$title_element[0] .= ' data-rel="prettyPhoto"';
				}

				if ( $target ) {
					$title_element[0] .= ' target="'. $target .'"';
				}

				$title_element[0] .= '>';
				$title_element[1] .= '</a>';

				if ( !empty( $title ) ) {
					$title = $title_element[0] . $title . $title_element[1];
				}

			}

			/**
			 *	Icon
			 */
			$parts['icon'] = cloudfw_make_icon( $icon );

			if ( ! empty( $parts['icon'] ) ) {
				if ( !empty($title_element[0]) && $link_icon ) {
					$parts['icon'] = $title_element[0] . $parts['icon'] . $title_element[1];
				}
				$parts['icon'] = "<span".
					cloudfw_make_class( array(
						'ui--icon-box-icon',
						'ui--animation',
					) ) .
					cloudfw_make_attribute( array(
						'data-fx' => $effect_icon,
						//'data-delay' => 1000,
					), false) .
				">". $parts['icon'] ."</span>";

			}

			/**
			 *	Title
			 */
			if ( ! empty( $title ) ) {
				$parts['title']  = "";

				$parts['title'] .= "<{$tag}" .
					cloudfw_make_class( array(
						'ui--icon-box-title',
						'ui--animation',
						 "text-" . $title_position,
					) ) .
					cloudfw_make_attribute( array(
						'data-fx' => $effect_title,
					), false) .
				">";

					$parts['title'] .= "<span " .
						cloudfw_make_style_attribute( array(
							'color'    => $title_color,
						), false ) .
					">";
						$parts['title'] .= $title;
					$parts['title'] .= "</span>";

				$parts['title'] .= "</{$tag}>";

			}

			/**
			 *	Text
			 */
			if ( !empty($content) ) {
				if ( $format ) {
					$content = do_shortcode( cloudfw_inline_format( $content ) );
				} else {
					$content = do_shortcode( $content );
				}

				$parts['text']  = '';
				$parts['text'] .= "<div ".
					cloudfw_make_class(array(
						"ui--animation",
						"ui--icon-box-text",
						"text-" . $content_align,
					)) .
					cloudfw_make_attribute( array(
						'data-fx' => $effect_text
					), false) .
				">";
					$parts['text'] .= $content;
				$parts['text'] .= "</div>";

			}

			/**
			 *
			 */
			$output_content  = '';
			$output_content .= $parts['icon'];
			$output_content .= "<div ".
				cloudfw_make_class(array(
					"ui--icon-box-content",
					//"ui--animation",
				)) .
			">";
				$output_content .= $parts['title'];
				$output_content .= $parts['text'];
			$output_content .= "</div>";

			/**
			 *	Box Container
			 */
			$box_classes = array();
			$box_classes[] = 'ui--icon-box';

			if ( $position == 'top' ) {
				$box_classes[] = 'position--top';
			} elseif ( $position == 'right' ) {
				$box_classes[] = 'position--right';
			} else {
				$box_classes[] = 'position--left';
			}

			/**
			 *	Output
			 */
			$output  = '';
			$output .= "<div ".
				cloudfw_make_class( $box_classes ) .
				cloudfw_make_style_attribute( array(
					'margin-top'    => $margin_top,
					'margin-bottom' => $margin_bottom,
				), false ) .
			">";
				$output .= $output_content;
			$output .= "</div>";
			unset($parts);

			return $output;
		}

		/** Admin Scheme */
		function scheme() {
			return array(
				'title'		=>	__('Text Block + Icon','envision-core'),
				'script'	=> array(
					'shortcode'		=> 'text_block',
					'tag_close'  	=> true,
					'attributes' 	=> array(
						'icon'             => array( 'e' => 'icon_box_pre_icon', 'required' => __('Please select an icon','envision-core') ),
						'link'  	       => array( 'e' => 'icon_box_link'),
						'target'  	       => array( 'e' => 'icon_box_target'),
						'lightbox' 	       => array( 'e' => 'icon_box_lightbox', 'onoff' => true ),
						'position'         => array( 'e' => 'icon_box_position'),
						'title'            => array( 'e' => 'icon_box_title' ),
						'title_color'      => array( 'e' => 'icon_box_title_color'),
						'title_position'   => array( 'e' => 'icon_box_title_position'),
						'content_align'    => array( 'e' => 'icon_box_content_position'),
						'link_icon' 	   => array( 'e' => 'icon_box_content_link_icon', 'onoff' => true ),
						'format' 	       => array( 'e' => 'icon_box_content_format', 'onoff' => true ),
						'content'          => array( 'e' => 'icon_box_content', 'force' => true, 'default' => __('Content Text','envision-core') ),
						'tag'              => array( 'e' => 'icon_box_element' ),
						'effect_icon'      => array( 'e' => 'icon_box_icon_custom_effect'),
						'effect_title'     => array( 'e' => 'icon_box_title_custom_effect'),
						'effect_text'      => array( 'e' => 'icon_box_text_custom_effect'),


						'margin_top'       => array( 'e' => 'margin_top' ),
						'margin_bottom'    => array( 'e' => 'margin_bottom' ),
					)
				),
				'data'		=>	array(


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Icon','envision-core'),
						'data'		=>	array(

							array(
								'type'		=> 'module',
								'title'		=> __('Icon Position','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_position',
										'value'		=>	$this->get_value('icon_box_position'),
										'ui'		=>	true,
										'main_class'=>  'input input_250',
										'source'	=>	array(
											'NULL'			=> __('Left','envision-core'),
											'right'			=> __('Right','envision-core'),
											'top' 			=> __('Top','envision-core'),
										)

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Icon','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'icon-selector',
										'id'		=>	'icon_box_pre_icon',
										'allow_custom' => true,
										'value'		=>	$this->get_value('icon_box_pre_icon'),
									), // #### element: 0

								)

							),

						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Title','envision-core'),
						'data'		=>	array(

							array(
								'type'		=> 'module',
								'title'		=> __('Title','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	'icon_box_title',
										'value'		=>	$this->get_value('icon_box_title'),
										'_class'	=>  'bold',
										'editor'	=>  true,
									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Title Size','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_element',
										'value'		=>	$this->get_value('icon_box_element'),
										'ui'		=>	true,
										'width'		=>	150,
										'source'	=>	array(
											'NULL'		=> __('Default','envision-core'),
											'h1'		=> 'H1',
											'h2'			=> 'H2',
											'h3'		=> 'H3',
											'h4'		=> 'H4',
											'h5'		=> 'H5',
											'h6'		=> 'H6',
											'strong'	=> __('Strong','envision-core'),
										)

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Title Align','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_title_position',
										'value'		=>	$this->get_value('icon_box_title_position'),
										'ui'		=>	true,
										'main_class'=>  'input input_250',
										'source'	=>	array(
											'NULL'			=> __('Left','envision-core'),
											'center' 		=> __('Center','envision-core'),
											'right' 		=> __('Right','envision-core'),
										)

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Title Color','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'color',
										'id'		=>	'icon_box_title_color',
										'value'		=>	$this->get_value('icon_box_title_color'),
										'style'		=>	'horizontal',

									), // #### element: 0

								)

							),

						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Text','envision-core'),
						'data'		=>	array(

							array(
								'type'		=> 'module',
								'title'		=> __('Content','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	'icon_box_content',
										'value'		=>	$this->get_value('icon_box_content'),
										'_class'	=>  'textarea_400px_2line redactor',
										'editor'	=>  true,
										'width'		=>	'90%',
										'line'		=>	5,
									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Content Align','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_content_position',
										'value'		=>	$this->get_value('icon_box_content_position'),
										'ui'		=>	true,
										'main_class'=>  'input input_250',
										'source'	=>	array(
											'NULL'			=> __('Left','envision-core'),
											'center' 		=> __('Center','envision-core'),
											'right' 		=> __('Right','envision-core'),
											'justify' 		=> __('Justify','envision-core'),
										)

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Auto Format','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	'icon_box_content_format',
										'value'		=>	$this->get_value('icon_box_content_format'),
										'desc'		=>	__('Automatically add paragraphs','envision-core'),
									), // #### element: 0

								)

							),

						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Link','envision-core'),
						'data'		=>	array(

							array(
								'type'		=> 'module',
								'title'		=> __('Link','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'page-selector',
										'id'		=>	'icon_box_link',
										'value'		=>	$this->get_value('icon_box_link'),
									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Link Target','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'ui'		=>	true,
										'id'		=>	'icon_box_target',
										'value'		=>	$this->get_value('icon_box_target'),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_link_targets'
										),
										'width'		=>  250,

									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Add the link to the icon?','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	'icon_box_content_link_icon',
										'value'		=>	$this->get_value('icon_box_content_link_icon', 'FALSE'),
									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('Show the link in Lightbox?','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	'icon_box_lightbox',
										'value'		=>	$this->get_value('icon_box_lightbox', 'FALSE'),
									), // #### element: 0

								)

							),

						)

					),


					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Custom Entrance Effects','envision-core'),
						'data'		=>	array(

							array(
								'type'		=> 'module',
								'title'		=> __('For Icon','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_icon_custom_effect',
										'value'		=>	$this->get_value('icon_box_icon_custom_effect'),
										'ui'		=>	true,
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_css_effect_list',
										),
										'width'		=>	400,
									),

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('For Title','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_title_custom_effect',
										'value'		=>	$this->get_value('icon_box_title_custom_effect'),
										'ui'		=>	true,
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_css_effect_list',
										),
										'width'		=>	400,
									),

								)

							),

							array(
								'type'		=> 'module',
								'title'		=> __('For Content','envision-core'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	'icon_box_text_custom_effect',
										'value'		=>	$this->get_value('icon_box_text_custom_effect'),
										'ui'		=>	true,
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_css_effect_list',
										),
										'width'		=>	400,
									),

								)

							),

						)

					),

					array(
						'type'		=>	'mini-section',
						'title'		=>	__('Margins','envision-core'),
						'data'		=>	array(

							array(
								'type'		=>	'global-scheme',
								'scheme'	=>	'margins',
								'this'		=>	$this
							),

						)

					),



				)

			);

		}

	}

}