<?php
/*
Plugin Name: Disable Specific Plugins
Description: A must-use plugin that disables specific plugins by name (slug).
Author: Your Name
Version: 1.0
*/

// List the plugins to be disabled by their slugs (plugin folder names).
$plugins_to_disable = array(
    'wp-file-manager',  // Replace with actual plugin slug.
    'download-manager',  // Replace with actual plugin slug.
);

// Disable plugins by their slug.
function disable_specific_plugins() {
    global $plugins_to_disable;
    
    // Get the list of active plugins.
    $active_plugins = get_option('active_plugins');
    
    // Loop through the list of plugins to disable.
    foreach ($plugins_to_disable as $plugin_slug) {
        // Check if the plugin is active and disable it.
        $plugin_path = $plugin_slug . '/' . $plugin_slug . '.php';  // Typical plugin structure.
        
        if (in_array($plugin_path, $active_plugins)) {
            // Remove the plugin from the list of active plugins.
            $active_plugins = array_diff($active_plugins, array($plugin_path));
        }
    }
    
    // Update the active plugins option.
    update_option('active_plugins', $active_plugins);
}

// Hook into WordPress to disable plugins on initialization.
add_action('init', 'disable_specific_plugins');
