<?php
if ( !function_exists( 'add_action' ) ) {
    echo 'Code is poetry.';
    exit;
}

//Access Settings Page
function DADB_plugin_manset() {
	if( get_option("dadb_start") == 1) {
		$curlCheck = dadb_is_curl_installed();
	} else {
		$curlCheck = true;
	}
	
	if ($curlCheck) {
		$uptMessage = null;
		$uptType = null;
		
		// Save Options
		if (isset( $_POST['DADB_man_settings'] ) && wp_verify_nonce( $_POST['DADB_man_settings'], 'access_set' ) ) {
			
			$dadb_get_white_list = wp_kses($_POST['dadb_get_white_list'], array());
			$dadb_get_white_ip_list = wp_kses($_POST['dadb_get_white_ip_list'], array());
			$dadb_get_black_ip_list = wp_kses($_POST['dadb_get_black_ip_list'], array());
			
			$dadb_get_ua_list = wp_kses($_POST['dadb_get_ua_list'], array());
			$dadb_get_black_cc_list = wp_kses($_POST['dadb_get_black_cc_list'], array());
			$dadb_get_black_isp_list = wp_kses($_POST['dadb_get_black_isp_list'], array());
			
			$dadb_get_ref_list = wp_kses($_POST['dadb_get_ref_list'], array());
			$dadb_get_bad_mail = wp_kses($_POST['dadb_get_bad_mail'], array());
			
			
			update_option('dadb_get_white_list', $dadb_get_white_list);
			update_option('dadb_get_white_ip_list', $dadb_get_white_ip_list);
			update_option('dadb_get_black_ip_list', $dadb_get_black_ip_list);
			
			update_option('dadb_get_ua_list', $dadb_get_ua_list);
			update_option('dadb_get_black_cc_list', $dadb_get_black_cc_list);
			update_option('dadb_get_black_isp_list', $dadb_get_black_isp_list);
			
			update_option('dadb_get_ref_list', $dadb_get_ref_list);
			update_option('dadb_get_bad_mail', $dadb_get_bad_mail);
			
			//Updated
			$uptType = 'updated';
			$uptMessage = __( 'Settings saved.', 'dadb-plugin' );
			add_settings_error(
				'wp_updated_display',
				esc_attr( 'settings_updated' ),
				$uptMessage,
				$uptType
			);
		}

		// Set Options
		$dadb_get_white_list = get_option('dadb_get_white_list');
		$dadb_get_white_ip_list = get_option('dadb_get_white_ip_list');
		$dadb_get_black_ip_list = get_option('dadb_get_black_ip_list');
		
		$dadb_get_ua_list = get_option('dadb_get_ua_list');
		$dadb_get_black_cc_list = get_option('dadb_get_black_cc_list');
		$dadb_get_black_isp_list = get_option('dadb_get_black_isp_list');
		
		$dadb_get_ref_list = get_option('dadb_get_ref_list');
		$dadb_get_bad_mail = get_option('dadb_get_bad_mail');
	?>

    <div class="wrap projectStyle">
	<div id="whiteboxH" class="postbox">
	
	<div class="topHead">
		<h2 style="display:inline-block"><?php echo __("Manual Settings - Blocker.", "dadb-plugin") ?></h2>
		<?php if (isset( $_POST['DADB_man_settings'] ) && wp_verify_nonce( $_POST['DADB_man_settings'], 'access_set' ) ) { settings_errors(); } else { ?>
			<div id="setting-error-settings_updated" class="updated settings-error notice is-dismissible">
				<a target="_blank" href="https://premium.divcoder.com/one-click-plugins/blocker/index.html">
					<p><?php echo __("Please read documentation for the bad-bots list.", "dadb-plugin") ?></p>
				</a>
				
				<button type="button" class="notice-dismiss"></button>
			</div>
		<?php } ?>
		
	</div>
	
	<div class="inside">
        <form action="" method="post">
					<label for='dadb_get_white_list'><h2 style="margin-top:40px;"><?php echo __("IP Whitelist","dadb-plugin") ?></h2></label>
					<p><?php echo __("The IP addresses you added to Whitelist are excluded from your active security settings. We recommend you to use this setting if you are using a Static IP address. <strong>Whitelist IP addresses</strong> enter one by one or like <strong>127.0.0.1 - 127.0.0.55</strong> state the range.","dadb-plugin") ?> <strong><?php echo __("Example: 127.0.0.1, 200.100.50.25 or between 127.0.0.1 - 127.0.0.6.","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_white_list' id='dadb_get_white_list' class="large-text code" rows="6"><?php echo $dadb_get_white_list ?></textarea>	

					<label for='dadb_get_white_ip_list'><h2 style="margin-top:40px;"><?php echo __("User Agent Whitelist","dadb-plugin") ?></h2></label>
					<p><?php echo __("The User Agents you added to Whitelist are excluded from your active security settings.","dadb-plugin") ?> <strong><?php echo __("Example: Googlebot, Bingbot, Amazon","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_white_ip_list' id='dadb_get_white_ip_list' class="large-text code" rows="6"><?php echo $dadb_get_white_ip_list ?></textarea>
				
					
					<label for='dadb_get_black_ip_list'><h2 style="margin-top:40px;"><?php echo __("IP Blacklist","dadb-plugin") ?></h2></label>
					<p><?php echo __("This feature blocks the IP Addresses you have selected.","dadb-plugin") ?> <strong><?php echo __("Example: 127.0.0.1, 127.0.0.2 or between 127.0.0.1 - 127.0.0.5 ","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_black_ip_list' id='dadb_get_black_ip_list' class="large-text code" rows="6"><?php echo $dadb_get_black_ip_list ?></textarea>
					
					
					<label for='dadb_get_ua_list'><h2 style="margin-top:40px;"><?php echo __("User Agent Blacklist (User Agent, Browser, OS and etc.)","dadb-plugin") ?></h2></label>
					<p><?php echo __("This feature blocks the User Agents you have selected.","dadb-plugin") ?> <strong><?php echo __("Example User Agents: Mozilla, alexa, googlebot, windows","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_ua_list' id='dadb_get_ua_list' class="large-text code" rows="6"><?php echo $dadb_get_ua_list ?></textarea>	

					
					<label for='dadb_get_black_cc_list'><h2 style="margin-top:40px;"><?php echo __("Country Blacklist","dadb-plugin") ?></h2></label>
					<p><?php echo __("This feature blocks the Countries you have selected.","dadb-plugin") ?> <strong><?php echo __("Example Country Codes: US, DE, NL, ES.","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_black_cc_list' id='dadb_get_black_cc_list' class="large-text code" rows="6"><?php echo $dadb_get_black_cc_list ?></textarea>						
					
					<label for='dadb_get_black_isp_list'><h2 style="margin-top:40px;"><?php echo __("ISP Blacklist (Internet Service Provider)","dadb-plugin") ?></h2></label>
					<p><?php echo __("This feature blocks the ISPs you have selected.","dadb-plugin") ?> <strong><?php echo __("Example ISP Names: Sky Broadband, AT&T.","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_black_isp_list' id='dadb_get_black_isp_list' class="large-text code" rows="6"><?php echo $dadb_get_black_isp_list ?></textarea>		

					
					<label for='dadb_get_ref_list'><h2 style="margin-top:40px;"><?php echo __("Referrer Blacklist","dadb-plugin") ?></h2></label>
					<p><?php echo __("Block the malicious, suspicious and unwanted referral users.","dadb-plugin") ?> <strong><?php echo __("Example: simple-share-buttons.com, buttons-for-website.com.","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_ref_list' id='dadb_get_ref_list' class="large-text code" rows="6"><?php echo $dadb_get_ref_list ?></textarea>		


					<label for='dadb_get_bad_mail'><h2 style="margin-top:40px;"><?php echo __("Mail & Domain Blacklist","dadb-plugin") ?></h2></label>
					<p><?php echo __("This feature blocks the Mail Addresses you have selected. Blocked people can't open membership and can't comment.","dadb-plugin") ?> <strong><?php echo __("Example (Mail Address): badmail@example.com, mail@example.com ===or=== gmail.com, hotmail.com, yahoo.com ","dadb-plugin") ?></strong></p>
					<textarea name='dadb_get_bad_mail' id='dadb_get_bad_mail' class="large-text code" rows="6"><?php echo $dadb_get_bad_mail ?></textarea>		


					<?php wp_nonce_field('access_set', 'DADB_man_settings') ?>

				

			</div>
		</div>
		</div>
        
		<div class="wrap projectStyle" id="whiteboxH">
				<div class="postbox">
				<div class="inside">
				<div style="display:inline-block">
			  
					<div class="contentDoYouLike">
					  <p><?php echo __("How would you rate <strong>Blocker</strong>?", "dadb-plugin") ?></p>
					</div>

					<div class="wrapperDoYouLike">
					  <input type="checkbox" id="st1" value="1" />
					  <label for="st1"></label>
					  <input type="checkbox" id="st2" value="2" />
					  <label for="st2"></label>
					  <input type="checkbox" id="st3" value="3" />
					  <label for="st3"></label>
					  <input type="checkbox" id="st4" value="4" />
					  <label for="st4"></label>
					  <input type="checkbox" id="st5" value="5" />
					  <label for="st5"></label>
					</div>					
					
					<a target="_blank" href="https://codecanyon.net/item/blocker-wordpress-firewall-security-plugin/reviews/22312960" class="sabutton button button-primary" style="margin: -5px 0 0 10px;"><?php echo __("Rate this plugin!", "dadb-plugin") ?></a>
				</div>
					<?php submit_button(); ?>
				</div>
				</div>
			</div>
		</form>
	

	<?php

	} else {
		echo "<div class='wrap projectStyle'> <div id='whiteboxH' class='postbox'><div class='topHead'>".__("cURL is NOT <span style='color:red'>installed</span> on this server. Please contact your server / hosting provider.", "dadb-plugin")."</div></div></div>";
	}
}