<?php
if ( !function_exists( 'add_action' ) ) {
    echo 'Code is poetry.';
    exit;
}

if( get_option("dadb_start") == 1 ) {
	
	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//STATS
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////	
	
	function updateOpt($name) {
	
		if ( get_option($name) == "" || get_option($name) < 1) {
			
			update_option( $name, "1");
			
		} else {
			
			$updateOpt = get_option($name) + 1;
			update_option( $name, $updateOpt);
			
		}
		
	}
	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//cURL Check
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	function dadb_is_curl_installed() {
		if  (in_array  ('curl', get_loaded_extensions())) {
			return true;
		}
		else {
			return false;
		}
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//User Agent
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	$user_agent = $_SERVER['HTTP_USER_AGENT'];


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//IP Address
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	function getIpAddress() {
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		
		return $ip;
	}
	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	// White List Check
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getWhiteList($whitelist) {
		$ip = getIpAddress();
				
		$white_list_arr = explode(", ", $whitelist);
		$inArrayCheck = "unknown";
		
		// Check IP
		if (in_array($ip, $white_list_arr)) 
			$inArrayCheck = "true";
		
		foreach ($white_list_arr as $k => $v) {
		if (substr_count($v, '-')) {
				$curr_ip_range = explode('-', $v);
				$high_ip = ip2long(trim($curr_ip_range[1]));
				$low_ip = ip2long(trim($curr_ip_range[0]));
				$checked_ip = ip2long($ip);
				if (sprintf("%u", $checked_ip) <= sprintf("%u", $high_ip)  && sprintf("%u", $low_ip) <= sprintf("%u", $checked_ip)) 
					$inArrayCheck = "true";
			}
		}

		return $inArrayCheck;
		
	}	
	
	function getUAWhiteList($whitelist) {
		global $user_agent;
		
		$ua = $user_agent;
				
		$white_list_arr = explode(", ", $whitelist);
		$inArrayCheck = "unknown";
		
		// Check UA
		foreach ($white_list_arr as $wha)
			if (stripos($ua, $wha) !== false)
				$inArrayCheck = "true";

		return $inArrayCheck;
		
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//Get Search Engine User Agent
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getSEUA() {
		
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {
			global $user_agent;
		
			$seua_array     = array(
								  '/googlebot/i'      =>  'google',
								  '/Googlebot-News/i'      =>  'google',
								  '/google/i'     =>  'google', 
								  '/slurp/i'     =>  'yahoo', 
								  '/bingbot/i'     =>  'bing',
								  '/bing/i'     =>  'bing',
								  '/yahoo/i'     =>  'yahoo',
								  '/yandexbot/i'     =>  'yandex',
								  '/yandex/i'     =>  'yandex',
								  '/teoma/i'     =>  'ask',
								  '/baidu/i'     =>  'baidu',
								  
							);

			foreach ($seua_array as $regex => $value)
				if (preg_match($regex, $user_agent))
					$seua_platform = $value;
		

			@$hostname = strtolower(gethostbyaddr(getIpAddress()));
		
			if (strpos(strtolower($seua_platform), "google") !== false) {
				
				if (strpos($hostname, "googlebot.com") !== false OR strpos($hostname, "google.com") !== false) {
					$seua_echo = "true";
				} else {
					$seua_echo = "unknown";
				}
				
			} else if (strpos(strtolower($seua_platform), "bing") !== false) {
				
				if (strpos($hostname, "search.msn.com") !== false OR strpos($hostname, "bing.com") !== false OR strpos($hostname, "msn.com") !== false) {
					$seua_echo = "true";
				} else {
					$seua_echo = "unknown";
				}
			} else if (strpos(strtolower($seua_platform), "yahoo") !== false) {
				
				if (strpos($hostname, "yahoo.com") !== false OR strpos($hostname, "crawl.yahoo.net") !== false OR strpos($hostname, "yandex.com") !== false) {
					$seua_echo = "true";
				} else {
					$seua_echo = "unknown";
				}
			} else if (strpos(strtolower($seua_platform), "yandex") !== false) {
				
				if (strpos($hostname, "yandex.com") !== false OR strpos($hostname, "yandex.ru") !== false OR strpos($hostname, "yandex.net") !== false OR strpos($hostname, "yandex.com.tr") !== false) {
					$seua_echo = "true";
				} else {
					$seua_echo = "unknown";
				}
			} else if (strpos(strtolower($seua_platform), "ask") !== false) {
				
				if (strpos($hostname, "ask.com") !== false) {
					$seua_echo = "true";
				} else {
					$seua_echo = "unknown";
				}
			} else if (strpos(strtolower($seua_platform), "baidu") !== false) {
				
				if (strpos($hostname, "baidu.com") !== false OR strpos($hostname, "baidu.jp") !== false ) {
					$seua_echo = "true";
				} else {
					$seua_echo = "unknown";
				}
			} else {
				$seua_echo  = "false";
			}
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$seua_echo = "true";
		}
		
		return $seua_echo;
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//Tor Check
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getTor() {
		
		$ip = getIpAddress();
		
		$tor_dns_look = array(
			"tor.dan.me.uk",
			"tor.dnsbl.sectoor.de"
		);
		$get_tor_ip = implode(".", array_reverse(explode(".", $ip)));
		
		foreach ($tor_dns_look as $torhost) {
			if (checkdnsrr($get_tor_ip . "." . $torhost . ".", "A")) {
				$torIP = "true";
			} else {
				$torIP = "unknown";
			}
		}
		
		return $torIP;
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//getIPInfo
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getIPInfo ($country=null, $isp=null ) {
		
		$ip = getIpAddress();

		//Check User Agent
		$get_useragent = $_SERVER['HTTP_USER_AGENT'];

		$url = 'http://ip-api.com/php/'.$ip.'?fields=countryCode,isp,status,message';
		$ch  = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_ENCODING, 'gzip,deflate');
		curl_setopt($ch, CURLOPT_USERAGENT, $get_useragent);
		curl_setopt($ch, CURLOPT_REFERER, "https://google.com");
		$proxy_yn = @unserialize(curl_exec($ch));
		curl_close($ch);

		if($proxy_yn && $proxy_yn['status'] == 'success') {
			
			if ( $country == 1) 
				$getIPInfo = $proxy_yn['countryCode'];

			if ( $isp == 1) 
				$getIPInfo = $proxy_yn['isp'];
			
		} else {
			$getIPInfo = "unknown";
		}
		
		return $getIPInfo;
	}
	

	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//get Blacklist
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getIPBlacklist () {
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {
			$ip = getIpAddress();

			//Check User Agent
			$get_useragent = $_SERVER['HTTP_USER_AGENT'];

			$url = 'http://proxy.mind-media.com/block/proxycheck.php?ip=' . $ip;
			$ch  = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_ENCODING, 'gzip,deflate');
			curl_setopt($ch, CURLOPT_USERAGENT, $get_useragent);
			curl_setopt($ch, CURLOPT_REFERER, "https://google.com");
			$proxy_yn = curl_exec($ch);
			curl_close($ch);


			if ($proxy_yn =="Y") {
				$badIP = "true";
			} else {
				$badIP = "unknown";
			}
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$badIP = "unknown";
		}
		
		return $badIP;
	}
	
	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//get Blacklist with STOPFORUMSPAM
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getIPBlacklistSFP () {
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {
			$ip = getIpAddress();

			//Check User Agent
			$get_useragent = $_SERVER['HTTP_USER_AGENT'];

			$url = 'http://api.stopforumspam.org/api?ip=' . $ip . '&serial';
			$ch  = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_ENCODING, 'gzip,deflate');
			curl_setopt($ch, CURLOPT_USERAGENT, $get_useragent);
			curl_setopt($ch, CURLOPT_REFERER, "https://google.com");
			$getIPBlacklist = @unserialize(curl_exec($ch));
			curl_close($ch);

			if($getIPBlacklist && $getIPBlacklist['success'] == 1) {
				
				if ($getIPBlacklist['ip']['appears'] == 1) {
					if ($getIPBlacklist['ip']['confidence'] >= '40') {
						$getIPInfo = "true";
					} else {
						$getIPInfo = "unknown";
					}
					
				} else {
					$getIPInfo = "unknown";
				}
				
			} else {
				$getIPInfo = "unknown";
			} 
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$getIPInfo = "unknown";
		}
		
		return $getIPInfo;
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//IP, ISP and Country Code Check
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	function getCheckInfo($check, $blacklist) {
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {
			if ($check == 1) {
				$cc = getIPInfo(1);
			} else if ($check == 2) {
				$cc = getIPInfo(0, 1);
			} else if ($check == 3) {
				$cc = getIpAddress();
			}
			
			$ip = getIpAddress();		
			
			$black_list_arr = explode(", ", $blacklist);
			$inArrayCheck = "unknown";
			
			if ($check == 1 || $check == 2 ) {
				// Check CC or ISP
				if (in_array($cc, $black_list_arr)) 
					$inArrayCheck = "true";
				
			} else if ($check == 3) {
				// Check IP if without "-"
				if (in_array($cc, $black_list_arr)) 
					$inArrayCheck = "true";
				
				//CC Blacklist IP Array
				foreach ($black_list_arr as $k => $v) {
					if (substr_count($v, '-')) {
						$curr_ip_range = explode('-', $v);
						$high_ip = ip2long(trim($curr_ip_range[1]));
						$low_ip = ip2long(trim($curr_ip_range[0]));
						$checked_ip = ip2long($ip);
						if (sprintf("%u", $checked_ip) <= sprintf("%u", $high_ip)  && sprintf("%u", $low_ip) <= sprintf("%u", $checked_ip)) {
							$inArrayCheck = "true";
						}
					}
				}
			}
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$inArrayCheck = "unknown";
		}
		
		return $inArrayCheck;
		
	}
	

	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	// Bad Mail Checker
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getBadMails($mail, $list) {
				
		$badmailarray = explode(", ", $list);
		$ret = "unknown";
		
		foreach ($badmailarray as $badm) {
			
			if (stripos($badm, $mail) !== false) {
				
				$ret = "true";
				
			} else if (stripos($mail, $badm) !== false) {
				
				$ret = "true";
			}
			
		}

		
		return $ret;
	}
	
	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	// Bad Mail Checker with API
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getBadMailsWApi($mail) {
		
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {

			//Check User Agent
			$get_useragent = $_SERVER['HTTP_USER_AGENT'];

			$url = 'http://api.stopforumspam.org/api?email=' . $mail . '&serial';
			$ch  = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_ENCODING, 'gzip,deflate');
			curl_setopt($ch, CURLOPT_USERAGENT, $get_useragent);
			curl_setopt($ch, CURLOPT_REFERER, "https://google.com");
			$getIPBlacklist = @unserialize(curl_exec($ch));
			curl_close($ch);

			if($getIPBlacklist && $getIPBlacklist['success'] == 1) {
				
				if ($getIPBlacklist['email']['appears'] == 1) {
					if ($getIPBlacklist['email']['confidence'] >= '40') {
						$getIPInfo = "true";
					} else {
						$getIPInfo = "unknown";
					}
					
				} else {
					$getIPInfo = "unknown";
				}
				
			} else {
				$getIPInfo = "unknown";
			} 
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$getIPInfo = "unknown";
		}
		
		return $getIPInfo;
		
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//Get Safe Bots
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getSafeBots() {
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {
			global $user_agent;
			$os_platform  = "unknown";
			
			
			$os_array     = array(
								'/windows nt 10/i',
								'/windows nt 6.3/i',
								'/windows nt 6.2/i',
								'/windows nt 6.1/i',
								'/windows nt 6.0/i',
								'/windows nt 5.2/i',
								'/windows nt 5.1/i',
								'/windows xp/i',
								'/windows nt 5.0/i',
								'/windows me/i',
								'/win98/i',
								'/win95/i',
								'/win16/i',
								'/macintosh|mac os x/i',
								'/mac_powerpc/i',
								'/linux/i',
								'/ubuntu/i',
								'/iphone/i',
								'/ipod/i',
								'/ipad/i',
								'/android/i',
								'/CrOS/i',
								'/blackberry/i',
								'/SymbianOS/i',
								'/webos/i',
								'/msie/i',
								'/firefox/i',
								'/UCBrowser/i',
								'/safari/i',
								'/chrome/i',
								'/edge/i',
								'/opera|OPR/i',
								'/netscape/i',
								'/maxthon/i',
								'/konqueror/i',
								'/mobile/i',
								'/alexa/i',
								'/pinterest/i',
								'/facebook/i',
								'/Googlebot-News/i',
								'/slack/i',
								'/linkedin/i',
								'/pingdom/i',
								'/twitter/i',
								'/skype/i',
								'/DuckDuck/i',
								'/github/i',
								'/microsoft/i',
								'/instagram/i',
								'/youtube/i',
								'/twitch/i',
								'/reddit/i',
								'/quora/i',
								'/wikia/i',
								'/vk.com|vkshare/i',
							);

			foreach ($os_array as $regex)
				if (preg_match($regex, $user_agent))
					$os_platform = 'true';
				
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") { 
			$os_platform = 'true';
		}

		return $os_platform;
	}	
	

	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//get Browser, Useragent, OS
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getBlackUa($baduaarray) {
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {

			global $user_agent;
			
			$baduser    = "unknown";
			$ua         = $user_agent;
			$uarray_arr = explode(", ", $baduaarray);
			
			foreach ($uarray_arr as $kick_bad_bots)
				if (stripos($ua, $kick_bad_bots) !== false)
					$baduser = "true";
				
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$baduser = "unknown";
		}

		return $baduser;
	}


	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//get Check bad Ref Link
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////

	function getCheckRef ($badrefarray) {
		if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown") {
			$baduser = "unknown";
			$userref = $_SERVER["HTTP_REFERER"];
			$badaarray_arr = explode(", ", $badrefarray);

			foreach ($badaarray_arr as $kick_bad_bots)
				if (stripos($userref, $kick_bad_bots) !== false)
					$baduser = "true";
				
		} else if (getUAWhiteList(get_option("dadb_get_white_ip_list")) == "true" && getWhiteList(get_option("dadb_get_white_list")) == "true") {
			$baduser = "unknown";
		}

		return $baduser;
	}

	
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////
	//LOG FUNC
	/////////////////////////////
	/////////////////////////////
	/////////////////////////////	

	function logUpdate($type) {
		$checkOn = get_option("dadb_start_dash");
		
		if($checkOn == 1) {
			$getSave = get_option("dadb_savelog");
			$saveLimit = count($getSave);
			
			if($saveLimit <= "49" && !empty($getSave)) {

				$arr = array( 1 => getIpAddress(),	2 => getIPInfo(1),	3 => getIPInfo(0, 1), 4 => $type,	5 => current_time('mysql'));
				$already = get_option("dadb_savelog");
				
				$countArr = count($already);
				$countArrCounted = $countArr + 1;
				
				$alArr = $already;
				$alArr[$countArrCounted] = $arr;
				
				update_option("dadb_savelog", $alArr);
				
			} else if ($saveLimit > "49" && !empty($getSave)) {
				
				$arr = array( 1 => getIpAddress(),	2 => getIPInfo(1),	3 => getIPInfo(0, 1), 4 => $type,	5 => current_time('mysql'));
				$already = get_option("dadb_savelog");
				
				$alArr = $already;
				
				//unset first
				$key = key($alArr);
				unset($alArr[$key]);				
				
				//add last
				array_push($alArr, $arr);
				
				update_option("dadb_savelog", $alArr);
				
			} else {
				$arr = array(1 => array( 1 => getIpAddress(),	2 => getIPInfo(1),	3 => getIPInfo(0, 1), 4 => $type,	5 => current_time('mysql')));
				update_option("dadb_savelog", $arr);
			}
		}
		
	}

	
	/////////////////////

	/////////////////////////////////
	/////////////////////////////////
	/////////////////////////////////
	/////////////////////////////////
	// START FUNCTIONS
	/////////////////////////////////
	/////////////////////////////////
	/////////////////////////////////
	/////////////////////////////////

	//if user not admin
	include(ABSPATH . "wp-includes/pluggable.php"); 
	if ( !( current_user_can('administrator') )) {
		if ( getIpAddress() != $_SERVER['SERVER_ADDR'] ) {
		//if user not admin

			if( get_option("dadb_vpnproxy") == 1 ) {
				
				function preventVPNProxy() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKIPVPN']) || empty($_SESSION['CHECKIPVPN'])) {
					
						if (getSEUA() !== 'true') {
							if (getIPBlacklist() == 'true') {
									$_SESSION['CHECKIPVPN'] = "1";
									updateOpt("dadb_bu");
									logUpdate(__("VPN / PROXY", "dadb-plugin"));
									
									if( get_option("dadb_messag") == 1) {
										$message =  __('VPN / PROXY detected. Your IP address has been blocked.', 'dadb-plugin' );
										$title = 'VPN / PROXY';
										$args = array('response' => 403);
										wp_die( $message, $title, $args );
										exit(0);
									} else {
										header('HTTP/1.1 403 Forbidden');
										header('Status: 403 Forbidden');
										header('Connection: Close');
										//die
										exit;
									}
							}
						}
					} else if ($_SESSION['CHECKIPVPN'] == "1") {
						
						if( get_option("dadb_messag") == 1) {
							$message =  __('VPN / PROXY detected. Your IP address has been blocked.', 'dadb-plugin' );
							$title = 'VPN / PROXY';
							$args = array('response' => 403);
							wp_die( $message, $title, $args );
							exit(0);
						} else {
							header('HTTP/1.1 403 Forbidden');
							header('Status: 403 Forbidden');
							header('Connection: Close');
							//die
							exit;
						}
						
					}
					
				}
					
					
				add_action('init', 'preventVPNProxy');
			}

			if( get_option("dadb_maliip") == 1 ) {
				
				function preventMaliIP() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKIP']) || empty($_SESSION['CHECKIP'])) {
					
						if (getIPBlacklistSFP() == 'true') {
								$_SESSION['CHECKIP'] = "1";
								updateOpt("dadb_nn");
								logUpdate(__("Malicious IP", "dadb-plugin"));
								
								if( get_option("dadb_messag") == 1) {
									$message =  __('Malicious IP detected. Your IP address has been blocked.', 'dadb-plugin' );
									$title = 'Malicious IP';
									$args = array('response' => 403);
									wp_die( $message, $title, $args );
									exit(0);
								} else {
									header('HTTP/1.1 403 Forbidden');
									header('Status: 403 Forbidden');
									header('Connection: Close');
									//die
									exit;
								}
						}
						
					}  else if ($_SESSION['CHECKIP'] == "1") {
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Malicious IP detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Malicious IP';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
							
					}
				}
					
				add_action('init', 'preventMaliIP');
			}

			if( get_option("dadb_torip") == 1 ) {
				
				function preventTorIP() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKIP']) || empty($_SESSION['CHECKIP'])) {
						
						if (getTor() == 'true') {
								$_SESSION['CHECKIP'] = "1";
								updateOpt("dadb_bu");
								logUpdate(__("Tor Browser / DNS", "dadb-plugin"));
								
								if( get_option("dadb_messag") == 1) {
									$message =  __('Tor Browser / DNS detected. Your IP address has been blocked.', 'dadb-plugin' );
									$title = 'Tor Browser / DNS';
									$args = array('response' => 403);
									wp_die( $message, $title, $args );
									exit(0);
								} else {
									header('HTTP/1.1 403 Forbidden');
									header('Status: 403 Forbidden');
									header('Connection: Close');
									//die
									exit;
								}
						}
					}  else if ($_SESSION['CHECKIP'] == "1") {
							
						if( get_option("dadb_messag") == 1) {
							$message =  __('Tor Browser / DNS detected. Your IP address has been blocked.', 'dadb-plugin' );
							$title = 'Tor Browser / DNS';
							$args = array('response' => 403);
							wp_die( $message, $title, $args );
							exit(0);
						} else {
							header('HTTP/1.1 403 Forbidden');
							header('Status: 403 Forbidden');
							header('Connection: Close');
							//die
							exit;
						}
							
					}
				}
					
				add_action('init', 'preventTorIP');
			}

			if( get_option("dadb_fakesearch") == 1 ) {
				
				function preventFakeSearch() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKUA']) || empty($_SESSION['CHECKUA']) ) {
						
						if (getSEUA() == 'unknown') {
							$_SESSION['CHECKUA'] = "1";
							updateOpt("dadb_fn");
							logUpdate(__("Fake Search Engine", "dadb-plugin"));
							
								if( get_option("dadb_messag") == 1) {
									$message =  __('Fake Search Engine detected. Your IP address has been blocked.', 'dadb-plugin' );
									$title = 'Fake Search Engine';
									$args = array('response' => 403);
									wp_die( $message, $title, $args );
									exit(0);
								} else {
									header('HTTP/1.1 403 Forbidden');
									header('Status: 403 Forbidden');
									header('Connection: Close');
									//die
									exit;
								}
						} 
					
					}  else if ($_SESSION['CHECKUA'] == "1") {
						
						if( get_option("dadb_messag") == 1) {
							$message =  __('Fake Search Engine detected. Your IP address has been blocked.', 'dadb-plugin' );
							$title = 'Fake Search Engine';
							$args = array('response' => 403);
							wp_die( $message, $title, $args );
							exit(0);
						} else {
							header('HTTP/1.1 403 Forbidden');
							header('Status: 403 Forbidden');
							header('Connection: Close');
							//die
							exit;
						}
					}
				}
					
				add_action('init', 'preventFakeSearch');
			}

			if( get_option("dadb_fakeuser") == 1 ) {
				
				function preventFakeUser() {
					global $user_agent;
					
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKUA']) || empty($_SESSION['CHECKUA'])) {
					
					if (getSEUA() !== 'true') {
						if (strlen($user_agent) <= 9 || !isset($user_agent) || empty($user_agent)) {
							updateOpt("dadb_nn");
							logUpdate(__("Fake User / Bot", "dadb-plugin"));
							$_SESSION['CHECKUA'] = "1";
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Fake User / Bot detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Fake User / Bot';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
						}
					}
						
					}  else if ($_SESSION['CHECKUA'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Fake User / Bot detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Fake User / Bot';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
					
				add_action('init', 'preventFakeUser');
			}
			
			
			if( get_option("dadb_botacc") == 1 ) {
				
				function preventBotAcc() {
					
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKUA']) || empty($_SESSION['CHECKUA'])) {
						
						if (getSEUA() !== 'true') {
							if (getSafeBots() == 'unknown') {
								$_SESSION['CHECKUA'] = "1";
								updateOpt("dadb_nn");
								logUpdate(__("Unnecessary Bot", "dadb-plugin"));
								
								if( get_option("dadb_messag") == 1) {
									$message =  __('Unnecessary Bot detected. Your IP address has been blocked.', 'dadb-plugin' );
									$title = 'Unnecessary Bot';
									$args = array('response' => 403);
									wp_die( $message, $title, $args );
									exit(0);
								} else {
									header('HTTP/1.1 403 Forbidden');
									header('Status: 403 Forbidden');
									header('Connection: Close');
									//die
									exit;
								}
							}
						} 
					} else if ($_SESSION['CHECKUA'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Unnecessary Bot detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Unnecessary Bot';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
					
				add_action('init', 'preventBotAcc');
			}
			
			
			
			if( get_option("dadb_get_black_ip_list") !== "" && !empty(get_option("dadb_get_black_ip_list")) && getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown" ) {
				function addBlackIP() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKIP']) || empty($_SESSION['CHECKIP'])) {
						
						if(getCheckInfo(3, get_option("dadb_get_black_ip_list")) == "true") {
							updateOpt("dadb_bu");
							logUpdate(__("Blacklist - IP", "dadb-plugin"));
							$_SESSION['CHECKIP'] = "1";
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - IP detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist IP';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
						}
						
					} else if ($_SESSION['CHECKIP'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - IP detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist IP';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
				add_action ('init', 'addBlackIP');
			}	
			
			if( get_option("dadb_get_black_cc_list") !== "" && !empty(get_option("dadb_get_black_cc_list")) && getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown" ) {
				function addBlackCC() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKIP']) || empty($_SESSION['CHECKIP'])) {
						
						if(getCheckInfo(1, get_option("dadb_get_black_cc_list")) == "true") {
							updateOpt("dadb_bu");
							logUpdate(__("Blacklist - Country", "dadb-plugin"));
							$_SESSION['CHECKIP'] = "1";
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - Country detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist Country';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
						}
						
					} else if ($_SESSION['CHECKIP'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - Country detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist Country';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
				add_action ('init', 'addBlackCC');
			}	
			
			if( get_option("dadb_get_black_isp_list") !== "" && !empty(get_option("dadb_get_black_isp_list")) && getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown" ) {
				function addBlackISP() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKIP']) || empty($_SESSION['CHECKIP'])) {
						
						if(getCheckInfo(2, get_option("dadb_get_black_isp_list")) == "true") {
							updateOpt("dadb_bu");
							logUpdate(__("Blacklist - ISP", "dadb-plugin"));
							$_SESSION['CHECKIP'] = "1";
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - ISP detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist ISP';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
						}
						
					} else if ($_SESSION['CHECKIP'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - ISP detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist ISP';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
				add_action ('init', 'addBlackISP');
			}
			
			if( get_option("dadb_get_ref_list") !== "" && !empty(get_option("dadb_get_ref_list")) && getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown" ) {
				function addBlackRef() {
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKREF']) || empty($_SESSION['CHECKREF'])) {
						
						if(getCheckRef(get_option("dadb_get_ref_list")) == "true") {
							updateOpt("dadb_rn");
							logUpdate(__("Blacklist - Referral", "dadb-plugin"));
							$_SESSION['CHECKREF'] = "1";
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - Referral detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist Referral';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
						}
						
					} else if ($_SESSION['CHECKREF'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - Referral detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist Referral';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
				
				add_action ('init', 'addBlackRef');
			}	
			
			if( get_option("dadb_get_ua_list") !== "" && !empty(get_option("dadb_get_ua_list")) && getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown" ) {
				function addBlackUA() {	
					if (session_status() == PHP_SESSION_NONE) {
						session_start();
					}
					
					if(!isset($_SESSION['CHECKUA']) || empty($_SESSION['CHECKUA'])) {
						
						if(getBlackUa(get_option("dadb_get_ua_list")) == "true") {
							updateOpt("dadb_nn");
							logUpdate(__("Blacklist - User Agent", "dadb-plugin"));
							$_SESSION['CHECKUA'] = "1";
							
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - User Agent detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist User Agent';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
						}
						
					} else if ($_SESSION['CHECKUA'] == "1") {
						
							if( get_option("dadb_messag") == 1) {
								$message =  __('Blacklist - User Agent detected. Your IP address has been blocked.', 'dadb-plugin' );
								$title = 'Blacklist User Agent';
								$args = array('response' => 403);
								wp_die( $message, $title, $args );
								exit(0);
							} else {
								header('HTTP/1.1 403 Forbidden');
								header('Status: 403 Forbidden');
								header('Connection: Close');
								//die
								exit;
							}
					}
				}
				
				add_action ('init', 'addBlackUA');
			}
			
			if( get_option("dadb_get_bad_mail") !== "" && !empty(get_option("dadb_get_bad_mail")) && getUAWhiteList(get_option("dadb_get_white_ip_list")) == "unknown" && getWhiteList(get_option("dadb_get_white_list")) == "unknown" ) {
				function addMailCheck() {
					$mail = $_POST['user_email'];
					$mailcomment = $_POST['email'];
					
					$array = get_option('dadb_get_bad_mail');
					
					if (isset($mail)) {
						if( getBadMails($mail, $array) == "true" ) {
							updateOpt("dadb_bm");
							$message =  __('Your email has been blocked.', 'dadb-plugin' );
							$title = 'Spam Mail';
							$args = array('response' => 403);
							wp_die( $message, $title, $args );
							exit(0);	
						}
					} else if(isset($mailcomment)) {
						if( getBadMails($mailcomment, $array) == "true" ) {
							updateOpt("dadb_bcm");
							$message =  __('Your email has been blocked.', 'dadb-plugin' );
							$title = 'Spam Comment';
							$args = array('response' => 403);
							wp_die( $message, $title, $args );
							exit(0);
						}
					}
				}
				
				add_filter("register_post", "addMailCheck");
				add_filter("preprocess_comment", "addMailCheck");
				
			}	
			
			
			function addMailCheckWApi() {
				$mail = $_POST['user_email'];
				$mailcomment = $_POST['email'];
				
				if (isset($mail) && get_option("dadb_malimail") == 1) {
					if( getBadMailsWApi($mail) == "true" ) {
						updateOpt("dadb_bm");
						$message =  __('Your email has been blocked.', 'dadb-plugin' );
						$title = 'Spam Mail';
						$args = array('response' => 403);
						wp_die( $message, $title, $args );
						exit(0);	
					}
				} else if(isset($mailcomment) &&  get_option("dadb_malicomm") == 1) {
					if( getBadMailsWApi($mailcomment) == "true" ) {
						updateOpt("dadb_bcm");
						$message =  __('Your email has been blocked.', 'dadb-plugin' );
						$title = 'Spam Comment';
						$args = array('response' => 403);
						wp_die( $message, $title, $args );
						exit(0);
					}
				}
			}
				
			if( get_option("dadb_malimail") == 1 ) {	
				add_filter("register_post", "addMailCheckWApi");
			}	
			
			if( get_option("dadb_malicomm") == 1 ) {
				add_filter("preprocess_comment", "addMailCheckWApi");
			}	
			
		//if user not admin
		}
	}
	//if user not admin
}