<?php



//-----------------------------------------------------

    function trim_all( $str , $what = NULL , $with = ' ' )
    {
        if( $what === NULL )
        {
            //  Character      Decimal      Use
            //  "\0"            0           Null Character
            //  "\t"            9           Tab
            //  "\n"           10           New line
            //  "\x0B"         11           Vertical Tab
            //  "\r"           13           New Line in Mac
            //  " "            32           Space
           
            $what   = "\\x00-\\x20";    //all white-spaces and control chars
        }
       
        return trim( preg_replace( "/[".$what."]+/" , $with , $str ) , $what );
    }

//-----------------------------------------------------


function WPCPM_get_abs_path()
{
	return WP_PLUGIN_DIR . '/' . basename(dirname(__FILE__)) . '/';
}
	
//-----------------------------------------------------

function WPCPM_get_url_path()
{
	return WP_PLUGIN_URL . '/' . basename(dirname(__FILE__)) . '/';
}


//---------------------------------------------------- 

function WPCPM_init_options()
{	
	add_option(WPCPM_OPTIONS);
	
	$options['select']=1;
	$options['saveimg']='none';
	$options['CTRLA']=1;
	$options['CTRLC']=1;
	$options['CTRLX']=1;
	$options['CTRLV']=1;
	$options['CTRLS']=1;
	$options['rightclick']='none';
	$options['CTRLINPUT']=0;
	$options['image_save_msg']="You can not save images!";
	$options['no_menu_msg']="Context menu disabled!";
	$options['image_url']="";
	$options['image_link']="";
	$options['HTMLAD']="";
	$options['ptitle']="Advertisement";
	$options['pwidth']="300";
    $options['pheight']="300";

	update_option(WPCPM_OPTIONS,$options);
} 

//---------------------------------------------------- 

function WPCPM_update_my_options($options)
{	
	
	update_option(WPCPM_OPTIONS,$options);
} 

//---------------------------------------------------- 

function WPCPM_my_options()
{	
	$options=get_option(WPCPM_OPTIONS);
	if(!$options)
	{
		WPCPM_init_options();
		$options=get_option(WPCPM_OPTIONS);
	}
	return $options;			
}

//---------------------------------------------------- 

function WPCPM_option_msg($msg)
{	
	echo '<div id="message" class="updated"><p>' . $msg . '</p></div>';		
}
  
     
?>