<?php
/*
Plugin Name: WP Content Protection Manager
Plugin URI: http://www.clogica.com
Description: This plugin protects your content from steeling, it prevents content select and copy and also prevents image saving from context menu.
Author: Fakhri Alsadi
Version: 1.2
Author URI: http://www.clogica.com
*/
define( 'WPCPM_OPTIONS', 'WPCPM-options-group' );

require_once ('functions.php');

add_action('admin_menu', 'WPCPM_admin_menu');
add_action('wp_head', 'WPCPM_script');
add_action( 'wp_enqueue_scripts', 'WPCPM_enqueue_scripts' );
add_action('admin_enqueue_scripts', 'WPCPM_admin_scripts');

register_deactivation_hook( __FILE__ , 'WPCPM_uninstall' );


function WPCPM_admin_scripts() {

	if (isset($_GET['page']) && $_GET['page'] == 'wp-content-protection-manager.php') {
		wp_enqueue_media();
		wp_register_script('my-admin-js', WP_PLUGIN_URL.'/my-plugin/my-admin.js', array('jquery'));
		wp_enqueue_script('my-admin-js');
	}
	
}


//----------------------------------------------------

function WPCPM_enqueue_scripts() {
    
    wp_enqueue_script('jquery');

	wp_register_script( 'colorboxjs', WP_PLUGIN_URL . '/' . basename(dirname(__FILE__)) . '/colorbox/' . "jquery.colorbox-min.js",array( 'jquery' ) );
	wp_register_style( 'colorboxcss', WP_PLUGIN_URL . '/' . basename(dirname(__FILE__)) . '/colorbox/' . "colorbox.css" );
	
	wp_enqueue_script('jquery');
	wp_enqueue_script('colorboxjs');
	wp_enqueue_style('colorboxcss');

    
    
}

//----------------------------------------------------

function WPCPM_script()
{
$function="";
$options= WPCPM_my_options();

	if($options['select']==1 || $options['saveimg']==1 || $options['CTRLA']==1 || $options['CTRLC']==1 ||  $options['CTRLX']==1  || $options['CTRLV']==1 || $options['CTRLS']==1 || $options['cmenu']==1  ){
	
	
	$block_ctrl=false;
	$keys="";
	$text_keys="";
	
	if($options['CTRLA']==1 || $options['CTRLC']==1 ||  $options['CTRLX']==1  || $options['CTRLV']==1 || $options['CTRLS']==1)
	{
		$block_ctrl=true;
		
		if($options['CTRLA']==1)
			if($keys=='')
				$keys=' key == 65 ';
			else
				$keys= $keys . ' || key == 65 ';
				
		if($options['CTRLC']==1)
			if($keys=='')
				$keys=' key == 67 ';
			else
				$keys= $keys . ' || key == 67 ';
		
		if($options['CTRLX']==1)
			if($keys=='')
				$keys=' key == 88 ';
			else
				$keys= $keys . ' || key == 88 ';
				
		if($options['CTRLV']==1)
			if($keys=='')
				$keys=' key == 86 ';
			else
				$keys= $keys . ' || key == 86 ';
				
		$text_keys = $keys;
		
		if($options['CTRLS']==1)
			if($keys=='')
				$keys=' key == 83 ';
			else
				$keys= $keys . ' || key == 83 ';
		
	}
	
	$ptitle=$options['ptitle'];
	
	$imghtml = "<img border=\"0\" src=\"". $options['image_url'] . "\">";
	if($options['image_link']!='')
	$imghtml = "<a target=\"_self\" href=\"" . $options['image_link'] . "\">" . $imghtml . "</a>";
	
	$width=intval($options['pwidth']) + 43;
	$height=intval($options['pheight']) + 75;
	
	
	$when_img_save="alert(image_save_msg);";
	$when_context_menu="alert(no_menu_msg);";
	
	if($options['saveimg'] == 'imageAD')
	  $when_img_save="show_IMG();";
	elseif($options['saveimg'] == 'HTMLAD')
	  $when_img_save="show_HTML();";
	  
	if($options['rightclick'] == 'imageAD')
	  $when_context_menu="show_IMG();";
	elseif($options['rightclick'] == 'HTMLAD')
	  $when_context_menu="show_HTML();";

	
	
	$script=" <script type='text/javascript'>
	var image_save_msg='" . $options['image_save_msg']  . "';
	var no_menu_msg='" . $options['no_menu_msg']  . "';
	
	
	function show_HTML()
	{
	    jQuery(function ($) {
        $.colorbox({html:'" . $options['HTMLAD'] . "',width:'" . $width . "px', height:'" . $height . "px' ,title: '$ptitle'  });
        });
	}
	
	
	function show_IMG()
	{
	    jQuery(function ($) {
        $.colorbox({html:'" . $imghtml . "',width:'" . $width . "px', height:'" . $height . "px' ,title: '$ptitle'  });
        });
	}
	
	
	";
	
	if($block_ctrl)
	$script = $script . " function disableCTRL(e)
	{
		var allow_input_textarea = true;
		var key; isCtrl = false;
		if(window.event)
			{ key = window.event.keyCode;if(window.event.ctrlKey)isCtrl = true; ";
			
					if($options['CTRLINPUT']==1)$script = $script . "if( (window.event.srcElement.nodeName =='INPUT' || window.event.srcElement.nodeName=='TEXTAREA') && isCtrl && ($text_keys))
					return true;";
					
		$script = $script .  " }
		else
			{ key = e.which; if(e.ctrlKey) isCtrl = true; ";
					if($options['CTRLINPUT']==1) $script = $script . "if( (e.target.nodeName =='INPUT' || e.target.nodeName =='TEXTAREA') && isCtrl && ($text_keys)) 
					return true; ";
			$script = $script . " }
	        
	     if(isCtrl && ($keys))
	          return false;
	          else
	          return true;} ";
	          
	if($options['select']==1)
	$script = $script . "          
	function disableselect(e)
	{	
	    if(e.target.nodeName !='INPUT' && e.target.nodeName !='TEXTAREA' && e.target.nodeName !='HTML' )
		return false;
	}
	function disableselect_ie()
	{	    
    	if(window.event.srcElement.nodeName !='INPUT' && window.event.srcElement.nodeName !='TEXTAREA')
		return false;
	}	
	function reEnable()
	{
		return true;
	}";
	
	
	
	
	if($options['saveimg']!='none' || $options['rightclick']!='none') {
	
	if($options['saveimg']!='none' && $options['rightclick']!='none')
	$function = " function disablecmenu(e)
	{		
	if (document.all){
		if(window.event.srcElement.nodeName=='IMG')
 		{   $when_img_save 
 		    return false;
 		 }
 		else
 		{  $when_context_menu
 		    return false;
 		 } 
	 }else
	 {
	 	if(e.target.nodeName=='IMG')
	 		{
	 		$when_img_save
	 		return false;
	 		}
	 	else
	 		{
	 		$when_context_menu
	 		return false;
	 		}
	 }
 
	}";
	
	
	if($options['saveimg']!='none' && $options['rightclick']=='none')
	$function = " function disablecmenu(e)
	{		
	if (document.all){
		if(window.event.srcElement.nodeName=='IMG')
 		{
 		    $when_img_save
 		    return false; }
	 }else
	 {
	 	if(e.target.nodeName=='IMG')
	 		{
	 		$when_img_save
	 		return false;}
	 }
 
	}";	
	

	if($options['saveimg']=='none' && $options['rightclick']!='none')
	$function = " function disablecmenu(e)
	{		
	if (document.all){
		{
		    $when_context_menu 
		    return false;
		    }
	 }else
	 {
	 	{ 
	 	    $when_context_menu
	 	   return false;
	 	    } 
	 }
	}";		
	
	
	
	$script = $script . $function;

	 }


	 
	if($block_ctrl)
	$script = $script . " 
	document.onkeydown= disableCTRL; ";
	
	if($options['saveimg']!='none' || $options['rightclick']!='none')
	$script = $script . "
	document.oncontextmenu = disablecmenu;
	 ";
	
	
		
	if($options['select']==1)
	$script = $script . " 
	document.onselectstart=disableselect_ie;
	if(navigator.userAgent.indexOf('MSIE')==-1){
	document.onmousedown=disableselect;
	document.onclick=reEnable;
	}
	 ";
	
	$script = $script . "
	
	
	</script> ";
	
	echo $script;
	
	}



}

//----------------------------------------------------

function WPCPM_admin_menu() {
	add_options_page('WP Content Protection Manager', 'WP Content Protection Manager', 'manage_options', basename(__FILE__), 'WPCPM_options_menu'  );
}

//----------------------------------------------------
function WPCPM_options_menu() {
	
	if (!current_user_can('manage_options'))  {
			wp_die( __('You do not have sufficient permissions to access this page.') );
		}
		
	echo '<div class="wrap"><h2>WP Content Protection Manager</h2><br/>';
	include "option_page.php";
	echo '</div>';
}
//----------------------------------------------------

function WPCPM_uninstall(){

	delete_option(WPCPM_OPTIONS);
}


?>