<?php
    $install_plugins_url = "";

    if ( isset( $GLOBALS['tgmpa'] ) ) {
        $install_plugins_url = $GLOBALS['tgmpa']->get_tgmpa_url();
    }
?>
<div class="wrap about-wrap full-width-layout">
    <div class="headline-feature">
        <h2><?php esc_html_e( 'One more thing before continue', 'envision' ); ?></h2>
        <p class="lead-description"><?php echo wp_kses(
            sprintf(
                __( 'The theme needs to be installed <strong>Envision Core Plugin</strong> to have all functionalities. Please install and activate the plugin<br/>on %s page.', 'envision' ),
                '<a href="'. esc_url( $install_plugins_url ) .'">'. __('<strong>Apperance &rarr; Install Plugins</strong>', 'envision') .'</a>'
            ),
            array(
                'br' => true,
                'strong' => true,
                'a' => array(
                    'href' => true
                )
            )
        ); ?></p>
    </div>

    <div style="text-align: center;">
        <a href="<?php echo esc_url( $install_plugins_url ); ?>" class="button button-primary button-large"><?php esc_html_e('Go to Install Plugins page', 'envision'); ?></a>
        <a href="<?php echo esc_url( add_query_arg( null, array( 'cloudfw-dismiss-core-plugin-warn' => true ) ) ); ?>" class="button button-large"><?php esc_html_e('Dismiss', 'envision'); ?></a>
    </div>

    <hr />

    <div class="return-to-dashboard">
        <?php if ( current_user_can( 'update_core' ) && isset( $_GET['updated'] ) ) : ?>
            <a href="<?php echo esc_url( self_admin_url( 'update-core.php' ) ); ?>">
                <?php is_multisite() ? esc_html_e( 'Return to Updates', 'envision' ) : esc_html_e( 'Return to Dashboard &rarr; Updates', 'envision' ); ?>
            </a> |
        <?php endif; ?>
        <a href="<?php echo esc_url( self_admin_url() ); ?>"><?php is_blog_admin() ? esc_html_e( 'Go to Dashboard &rarr; Home', 'envision' ) : esc_html_e( 'Go to Dashboard', 'envision' ); ?></a>
    </div>
</div>